"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatItemContentInlinePromptEditor = ChatItemContentInlinePromptEditor;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _prompt_editor = require("../prompt_editor/prompt_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const textContainerClassName = (0, _css.css)`
  padding: 4px 0;
  img {
    max-width: 100%;
  }
`;
const editorContainerClassName = (0, _css.css)`
  padding: 12px 0;
`;
function ChatItemContentInlinePromptEditor({
  editing,
  loading,
  functionCall,
  content,
  role,
  onActionClick,
  onSendTelemetry,
  onSubmit
}) {
  return !editing ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasBorder: false,
    hasShadow: false,
    className: textContainerClassName
  }, /*#__PURE__*/_react.default.createElement(_public.MessageText, {
    content: content || '',
    loading: loading,
    onActionClick: onActionClick
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasBorder: false,
    hasShadow: false,
    className: editorContainerClassName
  }, /*#__PURE__*/_react.default.createElement(_prompt_editor.PromptEditor, {
    disabled: false,
    hidden: false,
    loading: false,
    initialFunctionCall: functionCall,
    initialContent: content,
    initialRole: role,
    onChangeHeight: _lodash.noop,
    onSubmit: onSubmit,
    onSendTelemetry: onSendTelemetry
  }));
}