"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatFlyout = ChatFlyout;
exports.FlyoutPositionMode = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _use_conversation_key = require("../../hooks/use_conversation_key");
var _use_conversation_list = require("../../hooks/use_conversation_list");
var _use_current_user = require("../../hooks/use_current_user");
var _use_genai_connectors = require("../../hooks/use_genai_connectors");
var _use_kibana = require("../../hooks/use_kibana");
var _use_knowledge_base = require("../../hooks/use_knowledge_base");
var _new_chat_button = require("../buttons/new_chat_button");
var _chat_body = require("./chat_body");
var _chat_inline_edit = require("./chat_inline_edit");
var _conversation_list = require("./conversation_list");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CONVERSATIONS_SIDEBAR_WIDTH = 260;
const CONVERSATIONS_SIDEBAR_WIDTH_COLLAPSED = 34;
const SIDEBAR_WIDTH = 400;
let FlyoutPositionMode = exports.FlyoutPositionMode = /*#__PURE__*/function (FlyoutPositionMode) {
  FlyoutPositionMode["PUSH"] = "push";
  FlyoutPositionMode["OVERLAY"] = "overlay";
  return FlyoutPositionMode;
}({});
function ChatFlyout({
  initialTitle,
  initialMessages,
  initialFlyoutPositionMode,
  isOpen,
  onClose
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const breakpoint = (0, _eui.useCurrentEuiBreakpoint)();
  const currentUser = (0, _use_current_user.useCurrentUser)();
  const connectors = (0, _use_genai_connectors.useGenAIConnectors)();
  const knowledgeBase = (0, _use_knowledge_base.useKnowledgeBase)();
  const [conversationId, setConversationId] = (0, _react.useState)(undefined);
  const [flyoutPositionMode, setFlyoutPositionMode] = (0, _react.useState)(initialFlyoutPositionMode || FlyoutPositionMode.OVERLAY);
  const [conversationsExpanded, setConversationsExpanded] = (0, _react.useState)(false);
  const [secondSlotContainer, setSecondSlotContainer] = (0, _react.useState)(null);
  const [isSecondSlotVisible, setIsSecondSlotVisible] = (0, _react.useState)(false);
  const {
    services: {
      plugins: {
        start: {
          observabilityAIAssistant: {
            ObservabilityAIAssistantMultipaneFlyoutContext
          }
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const conversationList = (0, _use_conversation_list.useConversationList)();
  const {
    key: bodyKey,
    updateConversationIdInPlace
  } = (0, _use_conversation_key.useConversationKey)(conversationId);
  const flyoutClassName = (0, _css.css)`
    max-inline-size: 100% !important;
  `;
  const sidebarClass = (0, _css.css)`
    max-width: ${conversationsExpanded ? CONVERSATIONS_SIDEBAR_WIDTH : CONVERSATIONS_SIDEBAR_WIDTH_COLLAPSED}px;
    min-width: ${conversationsExpanded ? CONVERSATIONS_SIDEBAR_WIDTH : CONVERSATIONS_SIDEBAR_WIDTH_COLLAPSED}px;
    border-right: solid 1px ${euiTheme.border.color};
  `;
  const expandButtonContainerClassName = (0, _css.css)`
    position: absolute;
    margin-top: 16px;
    margin-left: ${conversationsExpanded ? CONVERSATIONS_SIDEBAR_WIDTH - CONVERSATIONS_SIDEBAR_WIDTH_COLLAPSED : 5}px;
    z-index: 1;
  `;
  const expandButtonClassName = (0, _css.css)`
    color: ${euiTheme.colors.primary};
  `;
  const containerClassName = (0, _css.css)`
    height: 100%;
    flex-wrap: nowrap;
  `;
  const chatBodyContainerClassName = (0, _css.css)`
    min-width: 0;
  `;
  const hideClassName = (0, _css.css)`
    display: none;
  `;
  const newChatButtonClassName = (0, _css.css)`
    position: absolute;
    bottom: 30px;
    margin-left: ${conversationsExpanded ? CONVERSATIONS_SIDEBAR_WIDTH - CONVERSATIONS_SIDEBAR_WIDTH_COLLAPSED : 5}px;
    z-index: 1;
  `;
  const handleToggleFlyoutPositionMode = newFlyoutPositionMode => {
    setFlyoutPositionMode(newFlyoutPositionMode);
  };
  return isOpen ? /*#__PURE__*/_react.default.createElement(ObservabilityAIAssistantMultipaneFlyoutContext.Provider, {
    value: {
      container: secondSlotContainer,
      setVisibility: setIsSecondSlotVisible
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutResizable, {
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.chatFlyout.euiFlyoutResizable.aiAssistantForObservabilityLabel', {
      defaultMessage: 'AI Assistant for Observability Chat Flyout'
    }),
    className: flyoutClassName,
    closeButtonProps: {
      css: {
        marginRight: breakpoint === 'xs' ? euiTheme.size.xs : euiTheme.size.s,
        marginTop: breakpoint === 'xs' ? euiTheme.size.xs : euiTheme.size.s
      }
    },
    paddingSize: "m",
    pushAnimation: true,
    minWidth: SIDEBAR_WIDTH,
    size: getFlyoutWidth({
      breakpoint,
      expanded: conversationsExpanded,
      isSecondSlotVisible
    }),
    type: flyoutPositionMode,
    onClose: () => {
      onClose();
      setIsSecondSlotVisible(false);
      if (secondSlotContainer) {
        _reactDom.default.unmountComponentAtNode(secondSlotContainer);
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    className: containerClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: breakpoint === 'xs' ? hideClassName : sidebarClass
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    className: expandButtonContainerClassName,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: conversationsExpanded ? _i18n.i18n.translate('xpack.observabilityAiAssistant.chatFlyout.euiToolTip.collapseConversationListLabel', {
        defaultMessage: 'Collapse conversation list'
      }) : _i18n.i18n.translate('xpack.observabilityAiAssistant.chatFlyout.euiToolTip.expandConversationListLabel', {
        defaultMessage: 'Expand conversation list'
      }),
      display: "block"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.chatFlyout.euiButtonIcon.expandConversationListLabel', {
        defaultMessage: 'Expand conversation list'
      }),
      className: expandButtonClassName,
      color: "text",
      "data-test-subj": "observabilityAiAssistantChatFlyoutButton",
      iconType: conversationsExpanded ? 'transitionLeftIn' : 'transitionLeftOut',
      onClick: () => setConversationsExpanded(!conversationsExpanded)
    }))
  }), conversationsExpanded ? /*#__PURE__*/_react.default.createElement(_conversation_list.ConversationList, {
    conversations: conversationList.conversations,
    isLoading: conversationList.isLoading,
    selectedConversationId: conversationId,
    onConversationDeleteClick: deletedConversationId => {
      conversationList.deleteConversation(deletedConversationId).then(() => {
        if (deletedConversationId === conversationId) {
          setConversationId(undefined);
        }
      });
    },
    onConversationSelect: nextConversationId => {
      setConversationId(nextConversationId);
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.observabilityAiAssistant.chatFlyout.euiToolTip.newChatLabel', {
        defaultMessage: 'New chat'
      }),
      display: "block"
    }, /*#__PURE__*/_react.default.createElement(_new_chat_button.NewChatButton, {
      "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.chatFlyout.euiButtonIcon.newChatLabel', {
        defaultMessage: 'New chat'
      }),
      collapsed: true,
      "data-test-subj": "observabilityAiAssistantNewChatFlyoutButton",
      onClick: () => {
        setConversationId(undefined);
      }
    })),
    className: newChatButtonClassName
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: chatBodyContainerClassName
  }, /*#__PURE__*/_react.default.createElement(_chat_body.ChatBody, {
    key: bodyKey,
    connectors: connectors,
    currentUser: currentUser,
    flyoutPositionMode: flyoutPositionMode,
    initialTitle: initialTitle,
    initialMessages: initialMessages,
    initialConversationId: conversationId,
    knowledgeBase: knowledgeBase,
    showLinkToConversationsApp: true,
    onConversationUpdate: conversation => {
      if (!conversationId) {
        updateConversationIdInPlace(conversation.conversation.id);
      }
      setConversationId(conversation.conversation.id);
      conversationList.conversations.refresh();
    },
    onToggleFlyoutPositionMode: handleToggleFlyoutPositionMode
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      maxWidth: isSecondSlotVisible ? SIDEBAR_WIDTH : 0,
      paddingTop: '56px'
    }
  }, /*#__PURE__*/_react.default.createElement(_chat_inline_edit.ChatInlineEditingContent, {
    setContainer: setSecondSlotContainer,
    visible: isSecondSlotVisible,
    style: {
      borderTop: `solid 1px ${euiTheme.border.color}`,
      borderLeft: `solid 1px ${euiTheme.border.color}`
    }
  }))))) : null;
}
const getFlyoutWidth = ({
  breakpoint,
  expanded,
  isSecondSlotVisible
}) => {
  if (breakpoint === 'xs') {
    return '90vw';
  }
  if (!expanded && !isSecondSlotVisible) {
    return '40vw';
  }
  if (expanded && !isSecondSlotVisible) {
    return `calc(40vw + ${CONVERSATIONS_SIDEBAR_WIDTH - CONVERSATIONS_SIDEBAR_WIDTH_COLLAPSED}px`;
  }
  if (!expanded && isSecondSlotVisible) {
    return `calc(40vw + ${SIDEBAR_WIDTH}px`;
  }
  return `calc(40vw + ${CONVERSATIONS_SIDEBAR_WIDTH - CONVERSATIONS_SIDEBAR_WIDTH_COLLAPSED}px + ${SIDEBAR_WIDTH}px`;
};