"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualizeESQLFunction = void 0;
var _common = require("@kbn/observability-ai-assistant-plugin/common");
var _visualize_esql = require("@kbn/observability-ai-assistant-plugin/common/functions/visualize_esql");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const visualizeESQLFunction = exports.visualizeESQLFunction = {
  name: 'visualize_query',
  visibility: _common.FunctionVisibility.UserOnly,
  description: 'Use this function to visualize charts for ES|QL queries.',
  descriptionForUser: 'Use this function to visualize charts for ES|QL queries.',
  parameters: {
    type: 'object',
    properties: {
      query: {
        type: 'string'
      },
      intention: {
        type: 'string',
        enum: _visualize_esql.VISUALIZE_ESQL_USER_INTENTIONS
      }
    },
    required: ['query', 'intention']
  },
  contexts: ['core']
};