"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDefinitionSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Validate that the value is a function
const functionSchema = _configSchema.schema.any({
  validate: value => {
    if (typeof value !== 'function') {
      return 'Must be a function';
    }
  }
});

// Validate that the value is a kbn config Schema (Type<any>)
const kbnConfigSchema = _configSchema.schema.any({
  validate: value => {
    if (!(0, _configSchema.isConfigSchema)(value)) {
      return 'Invalid schema type.';
    }
  }
});

// VersionableObject schema
const versionableObjectSchema = _configSchema.schema.object({
  schema: _configSchema.schema.maybe(kbnConfigSchema),
  down: _configSchema.schema.maybe(functionSchema),
  up: _configSchema.schema.maybe(functionSchema)
}, {
  unknowns: 'forbid'
});
const getOptionalInOutSchemas = props => _configSchema.schema.maybe(_configSchema.schema.object(props, {
  unknowns: 'forbid'
}));

// Schema to validate the "get" service objects
// Note: the "bulkGet" and "delete" services also use this schema as they allow the same IN/OUT objects
const getSchemas = getOptionalInOutSchemas({
  in: _configSchema.schema.maybe(_configSchema.schema.object({
    options: _configSchema.schema.maybe(versionableObjectSchema)
  }, {
    unknowns: 'forbid'
  })),
  out: _configSchema.schema.maybe(_configSchema.schema.object({
    result: _configSchema.schema.maybe(versionableObjectSchema)
  }, {
    unknowns: 'forbid'
  }))
});

// Schema to validate the "create" service objects
// Note: the "update" service also uses this schema as they allow the same IN/OUT objects
const createSchemas = getOptionalInOutSchemas({
  in: _configSchema.schema.maybe(_configSchema.schema.object({
    data: _configSchema.schema.maybe(versionableObjectSchema),
    options: _configSchema.schema.maybe(versionableObjectSchema)
  }, {
    unknowns: 'forbid'
  })),
  out: _configSchema.schema.maybe(_configSchema.schema.object({
    result: _configSchema.schema.maybe(versionableObjectSchema)
  }, {
    unknowns: 'forbid'
  }))
});

// Schema to validate the "search" service objects
const searchSchemas = getOptionalInOutSchemas({
  in: _configSchema.schema.maybe(_configSchema.schema.object({
    options: _configSchema.schema.maybe(versionableObjectSchema)
  }, {
    unknowns: 'forbid'
  })),
  out: _configSchema.schema.maybe(_configSchema.schema.object({
    result: _configSchema.schema.maybe(versionableObjectSchema)
  }, {
    unknowns: 'forbid'
  }))
});

// Schema to validate the "msearch" service objects
const mSearchSchemas = _configSchema.schema.maybe(_configSchema.schema.object({
  out: _configSchema.schema.maybe(_configSchema.schema.object({
    result: _configSchema.schema.maybe(versionableObjectSchema)
  }, {
    unknowns: 'forbid'
  }))
}));
const serviceDefinitionSchema = exports.serviceDefinitionSchema = _configSchema.schema.object({
  get: getSchemas,
  bulkGet: getSchemas,
  create: createSchemas,
  update: createSchemas,
  delete: getSchemas,
  search: searchSchemas,
  mSearch: mSearchSchemas
}, {
  unknowns: 'forbid'
});