"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewsfeedFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _newsfeed_header_nav_button = require("./newsfeed_header_nav_button");
var _empty_news = require("./empty_news");
var _loading_news = require("./loading_news");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const NewsfeedFlyout = props => {
  const {
    newsFetchResult,
    setFlyoutVisible
  } = (0, _react.useContext)(_newsfeed_header_nav_button.NewsfeedContext);
  const closeFlyout = (0, _react.useCallback)(() => setFlyoutVisible(false), [setFlyoutVisible]);
  const {
    showPlainSpinner,
    ...rest
  } = props;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, (0, _extends2.default)({}, rest, {
    onClose: closeFlyout,
    size: "s",
    "aria-labelledby": "flyoutSmallTitle",
    className: "kbnNews__flyout",
    "data-test-subj": "NewsfeedFlyout"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "flyoutSmallTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "newsfeed.flyoutList.whatsNewTitle",
    defaultMessage: "What's new at Elastic"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    className: 'kbnNews__flyoutAlerts'
  }, !newsFetchResult ? /*#__PURE__*/_react.default.createElement(_loading_news.NewsLoadingPrompt, {
    showPlainSpinner: props.showPlainSpinner
  }) : newsFetchResult.feedItems.length > 0 ? newsFetchResult.feedItems.map(item => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderAlert, {
      key: item.hash,
      title: item.title,
      text: item.description,
      "data-test-subj": "newsHeadAlert",
      action: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: item.linkUrl,
        external: true
      }, item.linkText),
      date: item.publishOn.format('DD MMMM YYYY'),
      badge: item.badge ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, item.badge) : undefined
    });
  }) : /*#__PURE__*/_react.default.createElement(_empty_news.NewsEmptyPrompt, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: closeFlyout,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "newsfeed.flyoutList.closeButtonLabel",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, newsFetchResult ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "newsfeed.flyoutList.versionTextLabel",
    defaultMessage: "{version}",
    values: {
      version: `Version ${newsFetchResult.kibanaVersion}`
    }
  }))) : null)))));
};
exports.NewsfeedFlyout = NewsfeedFlyout;