"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavigationServerPlugin = void 0;
var _common = require("../common");
var _ui_settings = require("./ui_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class NavigationServerPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
  }
  setup(core, plugins) {
    var _plugins$cloud;
    if ((_plugins$cloud = plugins.cloud) !== null && _plugins$cloud !== void 0 && _plugins$cloud.isCloudEnabled && !this.isServerless()) {
      const config = this.initializerContext.config.get();
      core.getStartServices().then(([coreStart, deps]) => {
        var _deps$cloudExperiment;
        (_deps$cloudExperiment = deps.cloudExperiments) === null || _deps$cloudExperiment === void 0 ? void 0 : _deps$cloudExperiment.getVariation(_common.SOLUTION_NAV_FEATURE_FLAG_NAME, false).then(value => {
          if (value) {
            core.uiSettings.registerGlobal((0, _ui_settings.getUiSettings)(config));
          } else {
            this.removeUiSettings(coreStart, (0, _ui_settings.getUiSettings)(config));
          }
        });
      });
    }
    return {};
  }
  start(core, plugins) {
    return {};
  }

  /**
   * Remove UI settings values that might have been set when the feature was enabled.
   * If the feature is disabled in kibana.yml, we want to remove the settings from the
   * saved objects.
   *
   * @param core CoreStart
   * @param uiSettings Navigation UI settings
   */
  removeUiSettings(core, uiSettings) {
    if (this.isServerless()) return;
    const savedObjectsClient = core.savedObjects.createInternalRepository();
    const uiSettingsClient = core.uiSettings.globalAsScopedToClient(savedObjectsClient);
    const keys = Object.keys(uiSettings);
    return uiSettingsClient.removeMany(keys, {
      validateKeys: false,
      handleWriteErrors: true
    });
  }
  isServerless() {
    return this.initializerContext.env.packageInfo.buildFlavor === 'serverless';
  }
}
exports.NavigationServerPlugin = NavigationServerPlugin;