"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolutionNavUserProfileToggle = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _userProfileComponents = require("@kbn/user-profile-components");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _use_solution_nav_userprofile_toggle = require("./use_solution_nav_userprofile_toggle");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SolutionNavUserProfileToggle = ({
  security,
  core,
  defaultOptOutValue
}) => {
  return /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserProfilesKibanaProvider, {
    core: core,
    security: security,
    toMountPoint: _reactKibanaMount.toMountPoint
  }, /*#__PURE__*/_react.default.createElement(SolutionNavUserProfileToggleUi, {
    defaultOptOutValue: defaultOptOutValue
  }));
};
exports.SolutionNavUserProfileToggle = SolutionNavUserProfileToggle;
function SolutionNavUserProfileToggleUi({
  defaultOptOutValue
}) {
  const toggleTextSwitchId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'toggleSolutionNavSwitch'
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    userProfileEnabled,
    toggle,
    hasOptOut
  } = (0, _use_solution_nav_userprofile_toggle.useSolutionNavUserProfileToggle)({
    defaultOptOutValue
  });
  if (!userProfileEnabled) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "tableOfContents",
    size: "s",
    onClick: () => {
      toggle(!hasOptOut);
    },
    "data-test-subj": "solutionNavToggle"
  }, _i18n.i18n.translate('navigation.userMenuLinks.useClassicNavigation', {
    defaultMessage: 'Use classic navigation'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      paddingRight: euiTheme.size.m
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: hasOptOut ? _i18n.i18n.translate('navigation.userMenuLinks.classicNavigationOnLabel', {
      defaultMessage: 'on'
    }) : _i18n.i18n.translate('navigation.userMenuLinks.classicNavigationOffLabel', {
      defaultMessage: 'off'
    }),
    showLabel: false,
    checked: hasOptOut,
    onChange: e => {
      toggle(e.target.checked);
    },
    "aria-describedby": toggleTextSwitchId,
    "data-test-subj": "solutionNavToggleSwitch",
    compressed: true
  })));
}