"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Logs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _lodash = require("lodash");
var _legacy_shims = require("../../legacy_shims");
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var _formatting = require("../../../common/formatting");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reason = require("./reason");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFormattedDateTimeLocal = timestamp => {
  var _Legacy$shims$uiSetti;
  const timezone = (_Legacy$shims$uiSetti = _legacy_shims.Legacy.shims.uiSettings) === null || _Legacy$shims$uiSetti === void 0 ? void 0 : _Legacy$shims$uiSetti.get('dateFormat:tz');
  return (0, _formatting.formatDateTimeLocal)(timestamp, timezone);
};
const columnTimestampTitle = _i18n.i18n.translate('xpack.monitoring.logs.listing.timestampTitle', {
  defaultMessage: 'Timestamp'
});
const columnLevelTitle = _i18n.i18n.translate('xpack.monitoring.logs.listing.levelTitle', {
  defaultMessage: 'Level'
});
const columnTypeTitle = _i18n.i18n.translate('xpack.monitoring.logs.listing.typeTitle', {
  defaultMessage: 'Type'
});
const columnMessageTitle = _i18n.i18n.translate('xpack.monitoring.logs.listing.messageTitle', {
  defaultMessage: 'Message'
});
const columnComponentTitle = _i18n.i18n.translate('xpack.monitoring.logs.listing.componentTitle', {
  defaultMessage: 'Component'
});
const columnNodeTitle = _i18n.i18n.translate('xpack.monitoring.logs.listing.nodeTitle', {
  defaultMessage: 'Node'
});
const columns = [{
  field: 'timestamp',
  name: columnTimestampTitle,
  width: '12%',
  render: timestamp => getFormattedDateTimeLocal(timestamp)
}, {
  field: 'level',
  name: columnLevelTitle,
  width: '5%'
}, {
  field: 'type',
  name: columnTypeTitle,
  width: '10%',
  render: type => (0, _lodash.upperFirst)(type)
}, {
  field: 'message',
  name: columnMessageTitle,
  width: '55%'
}, {
  field: 'component',
  name: columnComponentTitle,
  width: '18%'
}];
const clusterColumns = [{
  field: 'timestamp',
  name: columnTimestampTitle,
  width: '12%',
  render: timestamp => getFormattedDateTimeLocal(timestamp)
}, {
  field: 'level',
  name: columnLevelTitle,
  width: '5%'
}, {
  field: 'type',
  name: columnTypeTitle,
  width: '10%',
  render: type => (0, _lodash.upperFirst)(type)
}, {
  field: 'message',
  name: columnMessageTitle,
  width: '45%'
}, {
  field: 'component',
  name: columnComponentTitle,
  width: '15%'
}, {
  field: 'node',
  name: columnNodeTitle,
  width: '13%'
}];
function getLogsUiLink(clusterUuid, nodeId, indexUuid) {
  const params = [];
  if (clusterUuid) {
    params.push(`elasticsearch.cluster.uuid:${clusterUuid}`);
  }
  if (nodeId) {
    params.push(`elasticsearch.node.id:${nodeId}`);
  }
  if (indexUuid) {
    params.push(`elasticsearch.index.name:${indexUuid}`);
  }
  const base = _legacy_shims.Legacy.shims.infra.locators.logsLocator.getRedirectUrl({
    logView: {
      logViewId: _constants.INFRA_SOURCE_ID,
      type: 'log-view-reference'
    },
    ...(params.length ? {
      filter: params.join(' and ')
    } : {})
  });
  return base;
}
class Logs extends _react.PureComponent {
  renderLogs() {
    const {
      logs: {
        enabled,
        logs
      },
      nodeId,
      indexUuid
    } = this.props;
    if (!enabled) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      items: logs || [],
      columns: nodeId || indexUuid ? columns : clusterColumns
    });
  }
  renderNoLogs() {
    const {
      logs: {
        enabled,
        reason
      }
    } = this.props;
    if (enabled) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_reason.Reason, {
      reason: reason
    });
  }
  renderCallout() {
    const {
      capabilities: uiCapabilities,
      infra,
      kibanaServices
    } = _legacy_shims.Legacy.shims;
    const show = uiCapabilities.logs && uiCapabilities.logs.show;
    const {
      logs: {
        enabled
      },
      nodeId,
      clusterUuid,
      indexUuid
    } = this.props;
    if (!enabled || !show) {
      return null;
    }
    return infra ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "m",
      title: _i18n.i18n.translate('xpack.monitoring.logs.listing.calloutTitle', {
        defaultMessage: 'Want to see more log entries?'
      }),
      iconType: "logsApp"
    }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
      coreStart: kibanaServices
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.listing.linkText",
      defaultMessage: "Visit {link} to dive deeper.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: getLogsUiLink(clusterUuid, nodeId, indexUuid)
        }, _i18n.i18n.translate('xpack.monitoring.logs.listing.calloutLinkText', {
          defaultMessage: 'Logs'
        }))
      }
    }))) : null;
  }
  render() {
    const {
      nodeId,
      indexUuid,
      logs: {
        limit
      }
    } = this.props;
    let description;
    if (nodeId) {
      description = _i18n.i18n.translate('xpack.monitoring.logs.listing.nodePageDescription', {
        defaultMessage: 'Showing the most recent log entries for this node, up to {limit} total log entries.',
        values: {
          limit
        }
      });
    } else if (indexUuid) {
      description = _i18n.i18n.translate('xpack.monitoring.logs.listing.indexPageDescription', {
        defaultMessage: 'Showing the most recent log entries for this index, up to {limit} total log entries.',
        values: {
          limit
        }
      });
    } else {
      description = _i18n.i18n.translate('xpack.monitoring.logs.listing.clusterPageDescription', {
        defaultMessage: 'Showing the most recent log entries for this cluster, up to {limit} total log entries.',
        values: {
          limit
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.monitoring.logs.listing.pageTitle', {
      defaultMessage: 'Recent Log Entries'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), this.renderLogs(), this.renderNoLogs(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), this.renderCallout());
  }
}
exports.Logs = Logs;