"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildESQlTheme = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _theme = require("../../common/theme");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const buildRuleGroup = (0, _theme.themeRuleGroupBuilderFactory)(_constants.ESQL_TOKEN_POSTFIX);
const COMMANDS_COLORS = {
  dark: '#a68ac5',
  light: '#765b96'
};
const FUNCTIONS_COLORS = {
  dark: '#d97797',
  light: '#a34a68'
};
const buildESQlTheme = () => ({
  base: _uiTheme.darkMode ? 'vs-dark' : 'vs',
  inherit: true,
  rules: [
  // base
  ...buildRuleGroup(['explain', 'row', 'limit', 'ws', 'assign', 'comma', 'dot', 'first', 'last', 'opening_bracket', 'closing_bracket', 'quoted_identifier', 'src_ws', 'unquoted_identifier', 'pipe', 'not', 'percent', 'integer_literal', 'decimal_literal', 'src_unquoted_identifier', 'src_quoted_identifier', 'string'], _uiTheme.euiThemeVars.euiTextColor),
  // commands
  ...buildRuleGroup(['from', 'metadata', 'mv_expand', 'stats', 'dissect', 'grok', 'project', 'keep', 'rename', 'drop', 'eval', 'sort', 'by', 'where', 'not', 'is', 'like', 'rlike', 'in', 'as', 'expr_ws', 'row', 'show', 'meta', 'limit', 'nulls_ordering_direction', 'nulls_ordering', 'null', 'enrich', 'on', 'with'], _uiTheme.darkMode ? COMMANDS_COLORS.dark : COMMANDS_COLORS.light),
  // functions
  ...buildRuleGroup(['functions'], _uiTheme.darkMode ? FUNCTIONS_COLORS.dark : FUNCTIONS_COLORS.light),
  // operators
  ...buildRuleGroup(['or', 'and', 'rp', 'lp', 'plus', 'minus', 'asterisk', 'slash'], _uiTheme.euiThemeVars.euiTextSubduedColor),
  // comments
  ...buildRuleGroup(['line_comment', 'multiline_comment', 'expr_line_comment', 'expr_multiline_comment', 'src_line_comment', 'src_multiline_comment'], _uiTheme.darkMode ? _uiTheme.euiThemeVars.euiColorDarkestShade : _uiTheme.euiThemeVars.euiColorMediumShade)],
  colors: {}
});
exports.buildESQlTheme = buildESQlTheme;