"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildConsoleTheme = void 0;
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _theme = require("../../common/theme");
var _shared = require("./shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const buildRuleGroup = (0, _theme.themeRuleGroupBuilderFactory)();
const background = _uiTheme.euiThemeVars.euiColorLightestShade;
const methodTextColor = '#DD0A73';
const urlTextColor = '#00A69B';
const buildConsoleTheme = () => {
  const sharedTheme = (0, _shared.buildConsoleSharedTheme)();
  return {
    ...sharedTheme,
    rules: [...sharedTheme.rules, ...buildRuleGroup(['method'], (0, _eui.makeHighContrastColor)(methodTextColor)(background)), ...buildRuleGroup(['url'], (0, _eui.makeHighContrastColor)(urlTextColor)(background))]
  };
};
exports.buildConsoleTheme = buildConsoleTheme;