"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lexerRules = exports.languageConfiguration = void 0;
var _shared = require("./shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const languageConfiguration = exports.languageConfiguration = {
  ..._shared.consoleSharedLanguageConfiguration
};
const lexerRules = exports.lexerRules = {
  ..._shared.consoleSharedLexerRules,
  tokenizer: {
    ..._shared.consoleSharedLexerRules.tokenizer,
    root: [..._shared.consoleSharedLexerRules.tokenizer.root,
    // method
    (0, _shared.matchTokensWithEOL)('method', /([a-zA-Z]+)/, 'root', 'method_sep'),
    // whitespace
    (0, _shared.matchToken)('whitespace', '\\s+'),
    // text
    (0, _shared.matchToken)('text', '.+?')],
    method_sep: [
    // protocol host with slash
    (0, _shared.matchTokensWithEOL)(['whitespace', 'url.protocol_host', 'url.slash'], /(\s+)(https?:\/\/[^?\/,]+)(\/)/, 'root', 'url'),
    // variable template
    (0, _shared.matchTokensWithEOL)(['whitespace', 'variable.template'], /(\s+)(\${\w+})/, 'root', 'url'),
    // protocol host
    (0, _shared.matchTokensWithEOL)(['whitespace', 'url.protocol_host'], /(\s+)(https?:\/\/[^?\/,]+)/, 'root', 'url'),
    // slash
    (0, _shared.matchTokensWithEOL)(['whitespace', 'url.slash'], /(\s+)(\/)/, 'root', 'url'),
    // whitespace
    (0, _shared.matchTokensWithEOL)('whitespace', /(\s+)/, 'root', 'url')],
    url: [
    // variable template
    (0, _shared.matchTokensWithEOL)('variable.template', /(\${\w+})/, 'root'),
    // pathname
    (0, _shared.matchTokensWithEOL)('url.part', /([^?\/,\s]+)\s*/, 'root'),
    // comma
    (0, _shared.matchTokensWithEOL)('url.comma', /(,)/, 'root'),
    // slash
    (0, _shared.matchTokensWithEOL)('url.slash', /(\/)/, 'root'),
    // question mark
    (0, _shared.matchTokensWithEOL)('url.questionmark', /(\?)/, 'root', 'urlParams'),
    // comment
    (0, _shared.matchTokensWithEOL)(['whitespace', 'comment.punctuation', 'comment.line'], /(\s+)(\/\/)(.*$)/, 'root')],
    urlParams: [
    // param with variable template
    (0, _shared.matchTokensWithEOL)(['url.param', 'url.equal', 'variable.template'], /([^&=]+)(=)(\${\w+})/, 'root'),
    // param with value
    (0, _shared.matchTokensWithEOL)(['url.param', 'url.equal', 'url.value'], /([^&=]+)(=)([^&]*)/, 'root'),
    // param
    (0, _shared.matchTokensWithEOL)('url.param', /([^&=]+)/, 'root'),
    // ampersand
    (0, _shared.matchTokensWithEOL)('url.amp', /(&)/, 'root'),
    // comment
    (0, _shared.matchTokensWithEOL)(['whitespace', 'comment.punctuation', 'comment.line'], /(\s+)(\/\/)(.*$)/, 'root')]
  }
};