"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EDIT_SINGLE_METRIC_VIEWER_PANEL_ACTION = void 0;
exports.createEditSingleMetricViewerPanelAction = createEditSingleMetricViewerPanelAction;
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
var _open_in_single_metric_viewer_action = require("./open_in_single_metric_viewer_action");
var _http_service = require("../application/services/http_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EDIT_SINGLE_METRIC_VIEWER_PANEL_ACTION = exports.EDIT_SINGLE_METRIC_VIEWER_PANEL_ACTION = 'editSingleMetricViewerPanelAction';
function createEditSingleMetricViewerPanelAction(getStartServices) {
  return {
    id: 'edit-single-metric-viewer',
    type: EDIT_SINGLE_METRIC_VIEWER_PANEL_ACTION,
    order: 50,
    getIconType() {
      return 'pencil';
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.ml.actions.editSingleMetricViewerTitle', {
      defaultMessage: 'Edit single metric viewer'
    }),
    async execute(context) {
      if (!(0, _open_in_single_metric_viewer_action.isSingleMetricViewerEmbeddableContext)(context)) {
        throw new _public.IncompatibleActionError();
      }
      const [coreStart, pluginStart] = await getStartServices();
      try {
        const {
          resolveEmbeddableSingleMetricViewerUserInput
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../embeddables/single_metric_viewer/single_metric_viewer_setup_flyout')));
        const {
          mlApiServicesProvider
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../application/services/ml_api_service')));
        const httpService = new _http_service.HttpService(coreStart.http);
        const mlApiServices = mlApiServicesProvider(httpService);
        const {
          jobIds,
          selectedEntities,
          selectedDetectorIndex,
          panelTitle
        } = context.embeddable;
        const result = await resolveEmbeddableSingleMetricViewerUserInput(coreStart, pluginStart, mlApiServices, {
          jobIds: jobIds.getValue(),
          selectedDetectorIndex: selectedDetectorIndex.getValue(),
          selectedEntities: selectedEntities === null || selectedEntities === void 0 ? void 0 : selectedEntities.getValue(),
          title: panelTitle === null || panelTitle === void 0 ? void 0 : panelTitle.getValue()
        });
        context.embeddable.updateUserInput(result);
        context.embeddable.setPanelTitle(result.panelTitle);
      } catch (e) {
        return Promise.reject();
      }
    },
    async isCompatible(context) {
      let viewMode;
      if ((0, _presentationPublishing.apiPublishesViewMode)(context.embeddable)) {
        viewMode = context.embeddable.viewMode.getValue();
      }
      return (0, _open_in_single_metric_viewer_action.isSingleMetricViewerEmbeddableContext)(context) && viewMode === 'edit';
    }
  };
}