"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EDIT_ANOMALY_CHARTS_PANEL_ACTION = void 0;
exports.createEditAnomalyChartsPanelAction = createEditAnomalyChartsPanelAction;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
var _embeddables = require("../embeddables");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EDIT_ANOMALY_CHARTS_PANEL_ACTION = exports.EDIT_ANOMALY_CHARTS_PANEL_ACTION = 'editAnomalyChartsPanelAction';
function createEditAnomalyChartsPanelAction(getStartServices) {
  return {
    id: 'edit-anomaly-charts',
    type: EDIT_ANOMALY_CHARTS_PANEL_ACTION,
    getIconType(context) {
      return 'pencil';
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.ml.actions.editAnomalyChartsTitle', {
      defaultMessage: 'Edit anomaly charts'
    }),
    async execute({
      embeddable
    }) {
      if (!embeddable) {
        throw new Error('Not possible to execute an action without the embeddable context');
      }
      const [coreStart, deps] = await getStartServices();
      try {
        const {
          resolveEmbeddableAnomalyChartsUserInput
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../embeddables/anomaly_charts/anomaly_charts_setup_flyout')));
        const result = await resolveEmbeddableAnomalyChartsUserInput(coreStart, deps.data.dataViews, embeddable.getInput());
        embeddable.updateInput(result);
      } catch (e) {
        return Promise.reject();
      }
    },
    async isCompatible({
      embeddable
    }) {
      return embeddable.type === _embeddables.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE && embeddable.getInput().viewMode === _public.ViewMode.EDIT;
    }
  };
}