"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APPLY_ENTITY_FIELD_FILTERS_ACTION = void 0;
exports.createApplyEntityFieldFiltersAction = createApplyEntityFieldFiltersAction;
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _embeddables = require("../embeddables");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APPLY_ENTITY_FIELD_FILTERS_ACTION = exports.APPLY_ENTITY_FIELD_FILTERS_ACTION = 'applyEntityFieldFiltersAction';
function createApplyEntityFieldFiltersAction(getStartServices) {
  return {
    id: 'apply-entity-field-filters',
    type: APPLY_ENTITY_FIELD_FILTERS_ACTION,
    getIconType(context) {
      return 'filter';
    },
    getDisplayName() {
      return _i18n.i18n.translate('xpack.ml.actions.applyEntityFieldsFiltersTitle', {
        defaultMessage: 'Filter for value'
      });
    },
    async execute({
      data
    }) {
      if (!data) {
        throw new Error('No entities provided');
      }
      const [, pluginStart] = await getStartServices();
      const filterManager = pluginStart.data.query.filterManager;
      filterManager.addFilters(data.filter(d => d.operation === _mlAnomalyUtils.ML_ENTITY_FIELD_OPERATIONS.ADD).map(({
        fieldName,
        fieldValue
      }) => {
        return {
          $state: {
            store: _esQuery.FilterStateStore.APP_STATE
          },
          meta: {
            alias: _i18n.i18n.translate('xpack.ml.actions.entityFieldFilterAliasLabel', {
              defaultMessage: '{labelValue}',
              values: {
                labelValue: `${fieldName}:${fieldValue}`
              }
            }),
            controlledBy: _constants.CONTROLLED_BY_ANOMALY_CHARTS_FILTER,
            negate: false,
            disabled: false,
            type: 'phrase',
            key: fieldName,
            params: {
              query: fieldValue
            }
          },
          query: {
            match_phrase: {
              [fieldName]: fieldValue
            }
          }
        };
      }));
      data.filter(field => field.operation === _mlAnomalyUtils.ML_ENTITY_FIELD_OPERATIONS.REMOVE).forEach(field => {
        const filter = filterManager.getFilters().find(f => f.meta.key === field.fieldName && typeof f.meta.params === 'object' && 'query' in f.meta.params && f.meta.params.query === field.fieldValue);
        if (filter) {
          filterManager.removeFilter(filter);
        }
      });
    },
    async isCompatible({
      embeddable,
      data
    }) {
      return embeddable.type === _embeddables.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE && data !== undefined;
    }
  };
}