"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AnomalySwimLane = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _embeddables = require("../embeddables");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnomalySwimLane = ({
  id,
  jobIds,
  swimlaneType,
  viewBy,
  timeRange,
  filters,
  query,
  refreshConfig,
  perPage,
  executionContext
}) => {
  const embeddableApi = (0, _react.useRef)();
  const rawState = (0, _react.useMemo)(() => {
    return {
      jobIds,
      swimlaneType,
      refreshConfig,
      viewBy,
      timeRange
    };
  }, [jobIds, refreshConfig, swimlaneType, viewBy, timeRange]);
  (0, _react.useEffect)(function syncState() {
    if (!embeddableApi.current) return;
    embeddableApi.current.updateUserInput({
      jobIds,
      swimlaneType,
      viewBy
    });
  }, [jobIds, swimlaneType, viewBy]);
  (0, _react.useEffect)(function syncPagination() {
    if (!embeddableApi.current) return;
    embeddableApi.current.updatePagination({
      perPage,
      fromPage: 1
    });
  }, [perPage]);
  const parentApi = (0, _react.useMemo)(() => {
    const filters$ = new _rxjs.BehaviorSubject(filters);
    const query$ = new _rxjs.BehaviorSubject(query);
    const timeRange$ = new _rxjs.BehaviorSubject(timeRange);
    return {
      filters$,
      setFilters: newFilters => {
        filters$.next(newFilters);
      },
      query$,
      setQuery: newQuery => {
        query$.next(newQuery);
      },
      timeRange$,
      setTimeRange: newTimeRange => {
        timeRange$.next(newTimeRange);
      },
      executionContext
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(function syncTimeRange() {
    parentApi.setTimeRange(timeRange);
  }, [timeRange, parentApi]);
  (0, _react.useEffect)(function syncUnifiedSearch() {
    parentApi.setFilters(filters);
    parentApi.setQuery(query);
  }, [filters, query, parentApi]);
  return /*#__PURE__*/_react.default.createElement(_public.ReactEmbeddableRenderer, {
    maybeId: id,
    type: _embeddables.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE,
    state: {
      rawState
    },
    parentApi: parentApi,
    onApiAvailable: api => {
      embeddableApi.current = api;
    }
  });
};

// eslint-disable-next-line import/no-default-export
exports.AnomalySwimLane = AnomalySwimLane;
var _default = exports.default = AnomalySwimLane;