"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _esqlUtils = require("@kbn/esql-utils");
var _get_shared_ml_services = require("./application/services/get_shared_ml_services");
var _management = require("./application/management");
var _locator = require("./locator");
var _dependency_cache = require("./application/util/dependency_cache");
var _register_home_feature = require("./register_home_feature");
var _license = require("../common/license");
var _app = require("../common/constants/app");
var _shared_components = require("./shared_components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class MlPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "appUpdater$", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "locator", void 0);
    (0, _defineProperty2.default)(this, "sharedMlServices", void 0);
    (0, _defineProperty2.default)(this, "isServerless", false);
    (0, _defineProperty2.default)(this, "enabledFeatures", {
      ad: true,
      dfa: true,
      nlp: true
    });
    (0, _defineProperty2.default)(this, "experimentalFeatures", {
      ruleFormV2: false
    });
    this.initializerContext = initializerContext;
    this.isServerless = initializerContext.env.packageInfo.buildFlavor === 'serverless';
    (0, _app.initEnabledFeatures)(this.enabledFeatures, initializerContext.config.get());
    (0, _app.initExperimentalFeatures)(this.experimentalFeatures, initializerContext.config.get());
  }
  setup(core, pluginsSetup) {
    this.sharedMlServices = (0, _get_shared_ml_services.getMlSharedServices)(core.http);
    core.application.register({
      id: _app.PLUGIN_ID,
      title: _i18n.i18n.translate('xpack.ml.plugin.title', {
        defaultMessage: 'Machine Learning'
      }),
      order: 5000,
      euiIconType: _app.PLUGIN_ICON_SOLUTION,
      appRoute: _app.ML_APP_ROUTE,
      category: _public.DEFAULT_APP_CATEGORIES.kibana,
      updater$: this.appUpdater$,
      mount: async params => {
        const [coreStart, pluginsStart] = await core.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/app')));
        return renderApp(coreStart, {
          cases: pluginsStart.cases,
          charts: pluginsStart.charts,
          contentManagement: pluginsStart.contentManagement,
          dashboard: pluginsStart.dashboard,
          data: pluginsStart.data,
          dataViewEditor: pluginsStart.dataViewEditor,
          dataVisualizer: pluginsStart.dataVisualizer,
          embeddable: {
            ...pluginsSetup.embeddable,
            ...pluginsStart.embeddable
          },
          fieldFormats: pluginsStart.fieldFormats,
          home: pluginsSetup.home,
          kibanaVersion: this.initializerContext.env.packageInfo.version,
          lens: pluginsStart.lens,
          licenseManagement: pluginsSetup.licenseManagement,
          licensing: pluginsStart.licensing,
          management: pluginsSetup.management,
          maps: pluginsStart.maps,
          presentationUtil: pluginsStart.presentationUtil,
          savedObjectsManagement: pluginsStart.savedObjectsManagement,
          savedSearch: pluginsStart.savedSearch,
          security: pluginsStart.security,
          share: pluginsStart.share,
          triggersActionsUi: pluginsStart.triggersActionsUi,
          uiActions: pluginsStart.uiActions,
          unifiedSearch: pluginsStart.unifiedSearch,
          usageCollection: pluginsSetup.usageCollection
        }, params, this.isServerless, this.enabledFeatures, this.experimentalFeatures);
      }
    });
    if (pluginsSetup.share) {
      this.locator = pluginsSetup.share.url.locators.create(new _locator.MlLocatorDefinition());
    }
    if (pluginsSetup.management) {
      (0, _management.registerManagementSection)(pluginsSetup.management, core, {
        usageCollection: pluginsSetup.usageCollection
      }, this.isServerless, this.enabledFeatures).enable();
    }
    const licensing = pluginsSetup.licensing.license$.pipe((0, _rxjs.take)(1));
    licensing.pipe((0, _rxjs.mergeMap)(async license => {
      const mlEnabled = (0, _license.isMlEnabled)(license);
      const fullLicense = (0, _license.isFullLicense)(license);
      const [coreStart, pluginStart] = await core.getStartServices();
      const {
        capabilities
      } = coreStart.application;
      const mlCapabilities = capabilities.ml;
      const isEsqlEnabled = core.uiSettings.get(_esqlUtils.ENABLE_ESQL);

      // register various ML plugin features which require a full license
      // note including registerHomeFeature in register_helper would cause the page bundle size to increase significantly
      if (mlEnabled) {
        // add ML to home page
        if (pluginsSetup.home) {
          (0, _register_home_feature.registerHomeFeature)(pluginsSetup.home);
        }
        const {
          registerEmbeddables,
          registerMlUiActions,
          registerSearchLinks,
          registerCasesAttachments
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./register_helper')));
        registerSearchLinks(this.appUpdater$, fullLicense, mlCapabilities, this.isServerless, isEsqlEnabled);
        if (pluginsSetup.triggersActionsUi && (fullLicense && mlCapabilities.canUseMlAlerts && mlCapabilities.canGetJobs ||
        // Register rules for basic license to show them in the UI as disabled
        !fullLicense)) {
          // This module contains async imports itself, and it is conditionally loaded based on the license. We'll save
          // traffic if we load it async.
          const {
            registerMlAlerts
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./alerting/register_ml_alerts')));
          registerMlAlerts(pluginsSetup.triggersActionsUi, core.getStartServices, mlCapabilities, pluginsSetup.alerting);
        }
        if (fullLicense) {
          registerMlUiActions(pluginsSetup.uiActions, core);
          if (this.enabledFeatures.ad) {
            registerEmbeddables(pluginsSetup.embeddable, core);
            if (pluginsSetup.cases) {
              registerCasesAttachments(pluginsSetup.cases, coreStart, pluginStart);
            }
            if (pluginsSetup.maps) {
              // This module contains async imports itself, and it is conditionally loaded if maps is enabled. We'll save
              // traffic if we load it async.
              const {
                registerMapExtension
              } = await Promise.resolve().then(() => _interopRequireWildcard(require('./maps/register_map_extension')));

              // Pass canGetJobs as minimum permission to show anomalies card in maps layers
              await registerMapExtension(pluginsSetup.maps, core, {
                canGetJobs: mlCapabilities.canGetJobs,
                canCreateJobs: mlCapabilities.canCreateJob
              });
            }
          }
        }
      } else {
        // if ml is disabled in elasticsearch, disable ML in kibana
        this.appUpdater$.next(() => ({
          status: _public.AppStatus.inaccessible
        }));
      }
    })).subscribe();
    return {
      locator: this.locator,
      elasticModels: this.sharedMlServices.elasticModels
    };
  }
  start(core, deps) {
    var _this$sharedMlService, _this$sharedMlService2;
    (0, _dependency_cache.setDependencyCache)({
      docLinks: core.docLinks,
      http: core.http,
      i18n: core.i18n
    });
    return {
      locator: this.locator,
      elasticModels: (_this$sharedMlService = this.sharedMlServices) === null || _this$sharedMlService === void 0 ? void 0 : _this$sharedMlService.elasticModels,
      mlApi: (_this$sharedMlService2 = this.sharedMlServices) === null || _this$sharedMlService2 === void 0 ? void 0 : _this$sharedMlService2.mlApiServices,
      components: {
        AnomalySwimLane: _shared_components.AnomalySwimLane
      }
    };
  }
  stop() {}
}
exports.MlPlugin = MlPlugin;