"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalySourceFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/maps-plugin/common");
var _http_service = require("../application/services/http_service");
var _locator = require("../../common/constants/locator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class AnomalySourceFactory {
  constructor(getStartServices) {
    (0, _defineProperty2.default)(this, "type", _common.SOURCE_TYPES.ES_ML_ANOMALIES);
    this.getStartServices = getStartServices;
  }
  async getServices() {
    const [coreStart, pluginStart] = await this.getStartServices();
    const {
      mlApiServicesProvider
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../application/services/ml_api_service')));
    const mlLocator = pluginStart.share.url.locators.get(_locator.ML_APP_LOCATOR);
    const httpService = new _http_service.HttpService(coreStart.http);
    const mlResultsService = mlApiServicesProvider(httpService).results;
    return {
      mlResultsService,
      mlLocator
    };
  }
  async create() {
    const {
      mlResultsService,
      mlLocator
    } = await this.getServices();
    const {
      AnomalySource
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./anomaly_source')));
    AnomalySource.mlResultsService = mlResultsService;
    AnomalySource.mlLocator = mlLocator;
    return AnomalySource;
  }
}
exports.AnomalySourceFactory = AnomalySourceFactory;