"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveEmbeddableSingleMetricViewerUserInput = resolveEmbeddableSingleMetricViewerUserInput;
var _react = _interopRequireDefault(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public = require("@kbn/kibana-react-plugin/public");
var _single_metric_viewer_embeddable = require("./single_metric_viewer_embeddable");
var _resolve_job_selection = require("../common/resolve_job_selection");
var _single_metric_viewer_initializer = require("./single_metric_viewer_initializer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resolveEmbeddableSingleMetricViewerUserInput(coreStart, pluginStart, mlApiServices, input) {
  const {
    overlays,
    theme,
    i18n
  } = coreStart;
  const timefilter = pluginStart.data.query.timefilter.timefilter;
  return new Promise(async (resolve, reject) => {
    try {
      var _input$title;
      const {
        jobIds
      } = await (0, _resolve_job_selection.resolveJobSelection)(coreStart, pluginStart.data.dataViews, input !== null && input !== void 0 && input.jobIds ? input.jobIds : undefined, true);
      const title = (_input$title = input === null || input === void 0 ? void 0 : input.title) !== null && _input$title !== void 0 ? _input$title : (0, _single_metric_viewer_embeddable.getDefaultSingleMetricViewerPanelTitle)(jobIds);
      const {
        jobs
      } = await mlApiServices.getJobs({
        jobId: jobIds.join(',')
      });
      const modalSession = overlays.openModal((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
        services: {
          mlServices: {
            mlApiServices
          },
          ...coreStart
        }
      }, /*#__PURE__*/_react.default.createElement(_single_metric_viewer_initializer.SingleMetricViewerInitializer, {
        bounds: timefilter.getActiveBounds(),
        defaultTitle: title,
        initialInput: input,
        job: jobs[0],
        onCreate: explicitInput => {
          modalSession.close();
          resolve({
            jobIds,
            ...explicitInput
          });
        },
        onCancel: () => {
          modalSession.close();
          reject();
        }
      })), {
        theme,
        i18n
      }));
    } catch (error) {
      reject(error);
    }
  });
}