"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultSingleMetricViewerPanelTitle = exports.SingleMetricViewerEmbeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _lodash = require("lodash");
var _public = require("@kbn/embeddable-plugin/public");
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _common = require("@kbn/data-plugin/common");
var _embeddable_single_metric_viewer_container_lazy = require("./embeddable_single_metric_viewer_container_lazy");
var _ = require("..");
var _embeddable_loading_fallback = require("../common/components/embeddable_loading_fallback");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultSingleMetricViewerPanelTitle = jobIds => _i18n.i18n.translate('xpack.ml.singleMetricViewerEmbeddable.title', {
  defaultMessage: 'ML single metric viewer chart for {jobIds}',
  values: {
    jobIds: jobIds.join(', ')
  }
});
exports.getDefaultSingleMetricViewerPanelTitle = getDefaultSingleMetricViewerPanelTitle;
class SingleMetricViewerEmbeddable extends _public.Embeddable {
  constructor(initialInput, services, parent) {
    super(initialInput, {}, parent);
    (0, _defineProperty2.default)(this, "node", void 0);
    (0, _defineProperty2.default)(this, "reload$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "type", _.ANOMALY_SINGLE_METRIC_VIEWER_EMBEDDABLE_TYPE);
    // API
    (0, _defineProperty2.default)(this, "functionDescription", void 0);
    (0, _defineProperty2.default)(this, "jobIds", void 0);
    (0, _defineProperty2.default)(this, "selectedDetectorIndex", void 0);
    (0, _defineProperty2.default)(this, "selectedEntities", void 0);
    (0, _defineProperty2.default)(this, "apiSubscriptions", new _rxjs.Subscription());
    this.services = services;
    this.jobIds = (0, _public.embeddableInputToSubject)(this.apiSubscriptions, this, 'jobIds');
    this.functionDescription = (0, _public.embeddableInputToSubject)(this.apiSubscriptions, this, 'functionDescription');
    this.selectedDetectorIndex = (0, _public.embeddableInputToSubject)(this.apiSubscriptions, this, 'selectedDetectorIndex');
    this.selectedEntities = (0, _public.embeddableInputToSubject)(this.apiSubscriptions, this, 'selectedEntities');
  }
  updateUserInput(update) {
    this.updateInput(update);
  }
  reportsEmbeddableLoad() {
    return true;
  }
  onLoading() {
    this.renderComplete.dispatchInProgress();
    this.updateOutput({
      loading: true,
      error: undefined
    });
  }
  onError(error) {
    this.renderComplete.dispatchError();
    this.updateOutput({
      loading: false,
      error: {
        name: error.name,
        message: error.message
      }
    });
  }
  onRenderComplete() {
    this.renderComplete.dispatchComplete();
    this.updateOutput({
      loading: false,
      rendered: true,
      error: undefined
    });
  }
  render(node) {
    super.render(node);
    this.node = node;

    // required for the export feature to work
    this.node.setAttribute('data-shared-item', '');
    const I18nContext = this.services[0].i18n.Context;
    const theme$ = this.services[0].theme.theme$;
    const datePickerDeps = {
      ...(0, _lodash.pick)(this.services[0], ['http', 'notifications', 'theme', 'uiSettings', 'i18n']),
      data: this.services[1].data,
      uiSettingsKeys: _common.UI_SETTINGS,
      showFrozenDataTierChoice: false
    };
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
      theme$: theme$
    }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
      services: {
        mlServices: {
          ...this.services[2]
        },
        ...this.services[0],
        ...this.services[1]
      }
    }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_embeddable_loading_fallback.EmbeddableLoading, null)
    }, /*#__PURE__*/_react.default.createElement(_embeddable_single_metric_viewer_container_lazy.EmbeddableSingleMetricViewerContainer, {
      id: this.input.id,
      embeddableContext: this,
      embeddableInput$: this.getInput$(),
      services: this.services,
      refresh: this.reload$.asObservable(),
      onInputChange: this.updateInput.bind(this),
      onOutputChange: this.updateOutput.bind(this),
      onRenderComplete: this.onRenderComplete.bind(this),
      onLoading: this.onLoading.bind(this),
      onError: this.onError.bind(this)
    })))))), node);
  }
  destroy() {
    this.apiSubscriptions.unsubscribe();
    super.destroy();
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
  }
  reload() {
    this.reload$.next();
  }
  supportedTriggers() {
    return [];
  }
}
exports.SingleMetricViewerEmbeddable = SingleMetricViewerEmbeddable;