"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveJobSelection = resolveJobSelection;
var _moment = _interopRequireDefault(require("moment"));
var _rxjs = require("rxjs");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _job_selector = require("../../application/components/job_selector/job_selector");
var _job_selector_flyout = require("./components/job_selector_flyout");
var _get_services = require("../../application/util/get_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Handles Anomaly detection jobs selection by a user.
 * Intended to use independently of the ML app context,
 * for instance on the dashboard for embeddables initialization.
 *
 * @param coreStart
 * @param selectedJobIds
 */
async function resolveJobSelection(coreStart, dataViews, selectedJobIds, singleSelection = false) {
  const {
    http,
    uiSettings,
    theme,
    i18n,
    application: {
      currentAppId$
    }
  } = coreStart;
  return new Promise(async (resolve, reject) => {
    try {
      const maps = {
        groupsMap: (0, _job_selector.getInitialGroupsMap)([]),
        jobsMap: {}
      };
      const tzConfig = uiSettings.get('dateFormat:tz');
      const dateFormatTz = tzConfig !== 'Browser' ? tzConfig : _moment.default.tz.guess();
      const onFlyoutClose = () => {
        flyoutSession.close();
        reject();
      };
      const onSelectionConfirmed = async ({
        jobIds,
        groups
      }) => {
        await flyoutSession.close();
        resolve({
          jobIds,
          groups
        });
      };
      const flyoutSession = coreStart.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
        services: {
          ...coreStart,
          mlServices: (0, _get_services.getMlGlobalServices)(http, dataViews)
        }
      }, /*#__PURE__*/_react.default.createElement(_job_selector_flyout.JobSelectorFlyout, {
        selectedIds: selectedJobIds,
        withTimeRangeSelector: false,
        dateFormatTz: dateFormatTz,
        singleSelection: singleSelection,
        timeseriesOnly: true,
        onFlyoutClose: onFlyoutClose,
        onSelectionConfirmed: onSelectionConfirmed,
        maps: maps
      })), {
        theme,
        i18n
      }), {
        'data-test-subj': 'mlFlyoutJobSelector',
        ownFocus: true,
        closeButtonProps: {
          'aria-label': 'jobSelectorFlyout'
        }
      });

      // Close the flyout when user navigates out of the current plugin
      currentAppId$.pipe((0, _rxjs.skip)(1), (0, _rxjs.takeUntil)((0, _rxjs.from)(flyoutSession.onClose)), (0, _rxjs.distinctUntilChanged)()).subscribe(() => {
        flyoutSession.close();
      });
    } catch (error) {
      reject(error);
    }
  });
}