"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyChartsEmbeddableFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _app = require("../../../common/constants/app");
var _http_service = require("../../application/services/http_service");
var _ = require("..");
var _anomaly_explorer_charts_service = require("../../application/services/anomaly_explorer_charts_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class AnomalyChartsEmbeddableFactory {
  constructor(getStartServices) {
    (0, _defineProperty2.default)(this, "type", _.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE);
    (0, _defineProperty2.default)(this, "grouping", [{
      id: _app.PLUGIN_ID,
      getDisplayName: () => _app.ML_APP_NAME,
      getIconType: () => _app.PLUGIN_ICON
    }]);
    this.getStartServices = getStartServices;
  }
  async isEditable() {
    return true;
  }
  getDisplayName() {
    return _i18n.i18n.translate('xpack.ml.components.mlAnomalyExplorerEmbeddable.displayName', {
      defaultMessage: 'Anomaly chart'
    });
  }
  getDescription() {
    return _i18n.i18n.translate('xpack.ml.components.mlAnomalyExplorerEmbeddable.description', {
      defaultMessage: 'View anomaly detection results in a chart.'
    });
  }
  async getExplicitInput() {
    const [coreStart, deps] = await this.getServices();
    try {
      const {
        resolveEmbeddableAnomalyChartsUserInput
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./anomaly_charts_setup_flyout')));
      return await resolveEmbeddableAnomalyChartsUserInput(coreStart, deps.data.dataViews);
    } catch (e) {
      return Promise.reject();
    }
  }
  async getServices() {
    const [[coreStart, pluginsStart], {
      AnomalyDetectorService
    }, {
      fieldFormatServiceFactory
    }, {
      indexServiceFactory
    }, {
      mlApiServicesProvider
    }, {
      mlResultsServiceProvider
    }] = await Promise.all([await this.getStartServices(), await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/anomaly_detector_service'))), await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/field_format_service_factory'))), await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/util/index_service'))), await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/ml_api_service'))), await Promise.resolve().then(() => _interopRequireWildcard(require('../../application/services/results_service')))]);
    const httpService = new _http_service.HttpService(coreStart.http);
    const anomalyDetectorService = new AnomalyDetectorService(httpService);
    const mlApiServices = mlApiServicesProvider(httpService);
    const mlResultsService = mlResultsServiceProvider(mlApiServices);
    const anomalyExplorerService = new _anomaly_explorer_charts_service.AnomalyExplorerChartsService(pluginsStart.data.query.timefilter.timefilter, mlApiServices, mlResultsService);

    // Note on the following services:
    // - `mlIndexUtils` is just instantiated here to be passed on to `mlFieldFormatService`,
    //   but it's not being made available as part of global services. Since it's just
    //   some stateless utils `useMlIndexUtils()` should be used from within components.
    // - `mlFieldFormatService` is a stateful legacy service that relied on "dependency cache",
    //   so because of its own state it needs to be made available as a global service.
    //   In the long run we should again try to get rid of it here and make it available via
    //   its own context or possibly without having a singleton like state at all, since the
    //   way this manages its own state right now doesn't consider React component lifecycles.
    const mlIndexUtils = indexServiceFactory(pluginsStart.data.dataViews);
    const mlFieldFormatService = fieldFormatServiceFactory(mlApiServices, mlIndexUtils);
    return [coreStart, pluginsStart, {
      anomalyDetectorService,
      anomalyExplorerService,
      mlFieldFormatService,
      mlResultsService
    }];
  }
  async create(initialInput, parent) {
    const services = await this.getServices();
    const {
      AnomalyChartsEmbeddable
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./anomaly_charts_embeddable')));
    return new AnomalyChartsEmbeddable(initialInput, services, parent);
  }
}
exports.AnomalyChartsEmbeddableFactory = AnomalyChartsEmbeddableFactory;