"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultExplorerChartsPanelTitle = exports.AnomalyChartsEmbeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _embeddable_anomaly_charts_container_lazy = require("./embeddable_anomaly_charts_container_lazy");
var _ = require("..");
var _embeddable_loading_fallback = require("../common/components/embeddable_loading_fallback");
var _anomaly_detection_embeddable = require("../common/anomaly_detection_embeddable");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultExplorerChartsPanelTitle = jobIds => _i18n.i18n.translate('xpack.ml.anomalyChartsEmbeddable.title', {
  defaultMessage: 'ML anomaly charts for {jobIds}',
  values: {
    jobIds: jobIds.join(', ')
  }
});
exports.getDefaultExplorerChartsPanelTitle = getDefaultExplorerChartsPanelTitle;
class AnomalyChartsEmbeddable extends _anomaly_detection_embeddable.AnomalyDetectionEmbeddable {
  constructor(initialInput, services, parent) {
    super(initialInput, services[2].anomalyDetectorService, services[1].data.dataViews, parent);
    (0, _defineProperty2.default)(this, "node", void 0);
    (0, _defineProperty2.default)(this, "reload$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "type", _.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE);
    // API
    (0, _defineProperty2.default)(this, "jobIds", void 0);
    (0, _defineProperty2.default)(this, "entityFields", void 0);
    (0, _defineProperty2.default)(this, "apiSubscriptions", new _rxjs.Subscription());
    this.services = services;
    this.jobIds = (0, _public2.embeddableInputToSubject)(this.apiSubscriptions, this, 'jobIds');
    this.entityFields = (0, _public2.embeddableOutputToSubject)(this.apiSubscriptions, this, 'entityFields');
  }
  onLoading() {
    this.renderComplete.dispatchInProgress();
    this.updateOutput({
      loading: true,
      error: undefined
    });
  }
  onError(error) {
    this.renderComplete.dispatchError();
    this.updateOutput({
      loading: false,
      error: {
        name: error.name,
        message: error.message
      }
    });
  }
  onRenderComplete() {
    this.renderComplete.dispatchComplete();
    this.updateOutput({
      loading: false,
      rendered: true,
      error: undefined
    });
  }
  render(node) {
    super.render(node);
    this.node = node;

    // required for the export feature to work
    this.node.setAttribute('data-shared-item', '');
    const I18nContext = this.services[0].i18n.Context;
    const theme$ = this.services[0].theme.theme$;
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: theme$
    }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        mlServices: {
          ...this.services[2]
        },
        ...this.services[0],
        ...this.services[1]
      }
    }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_embeddable_loading_fallback.EmbeddableLoading, null)
    }, /*#__PURE__*/_react.default.createElement(_embeddable_anomaly_charts_container_lazy.EmbeddableAnomalyChartsContainer, {
      id: this.input.id,
      embeddableContext: this,
      embeddableInput: this.getInput$(),
      services: this.services,
      refresh: this.reload$.asObservable(),
      onInputChange: this.updateInput.bind(this),
      onOutputChange: this.updateOutput.bind(this),
      onRenderComplete: this.onRenderComplete.bind(this),
      onLoading: this.onLoading.bind(this),
      onError: this.onError.bind(this)
    }))))), node);
  }
  destroy() {
    super.destroy();
    this.apiSubscriptions.unsubscribe();
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
  }
  reload() {
    this.reload$.next();
  }
  supportedTriggers() {
    return [];
  }
}
exports.AnomalyChartsEmbeddable = AnomalyChartsEmbeddable;