"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterListsTable = FilterListsTable;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _delete_filter_list_modal = require("../components/delete_filter_list_modal");
var _use_create_url = require("../../../contexts/kibana/use_create_url");
var _locator = require("../../../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React table for displaying a table of filter lists.
 */

function UsedByIcon({
  usedBy
}) {
  // Renders a tick or cross in the 'usedBy' column to indicate whether
  // the filter list is in use in a detectors in any jobs.
  let icon;
  if (usedBy !== undefined && usedBy.jobs.length > 0) {
    icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "check",
      "aria-label": _i18n.i18n.translate('xpack.ml.settings.filterLists.table.inUseAriaLabel', {
        defaultMessage: 'In use'
      }),
      "data-test-subj": "mlFilterListUsedByIcon inUse"
    });
  } else {
    icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "cross",
      "aria-label": _i18n.i18n.translate('xpack.ml.settings.filterLists.table.notInUseAriaLabel', {
        defaultMessage: 'Not in use'
      }),
      "data-test-subj": "mlFilterListUsedByIcon notInUse"
    });
  }
  return icon;
}
UsedByIcon.propTypes = {
  usedBy: _propTypes.default.object
};
function NewFilterButton({
  canCreateFilter
}) {
  const redirectToNewFilterListPage = (0, _use_create_url.useCreateAndNavigateToMlLink)(_locator.ML_PAGES.FILTER_LISTS_NEW);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    key: "new_filter_list",
    onClick: redirectToNewFilterListPage,
    isDisabled: canCreateFilter === false,
    "data-test-subj": "mlFilterListsButtonCreate"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.filterLists.table.newButtonLabel",
    defaultMessage: "New"
  }));
}
function getColumns() {
  const columns = [{
    field: 'filter_id',
    name: _i18n.i18n.translate('xpack.ml.settings.filterLists.table.idColumnName', {
      defaultMessage: 'ID'
    }),
    render: id => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Link, {
      to: `/${_locator.ML_PAGES.FILTER_LISTS_EDIT}/${id}`,
      "data-test-subj": "mlEditFilterListLink"
    }, id),
    sortable: true,
    scope: 'row',
    'data-test-subj': 'mlFilterListColumnId'
  }, {
    field: 'description',
    name: _i18n.i18n.translate('xpack.ml.settings.filterLists.table.descriptionColumnName', {
      defaultMessage: 'Description'
    }),
    sortable: true,
    'data-test-subj': 'mlFilterListColumnDescription'
  }, {
    field: 'item_count',
    name: _i18n.i18n.translate('xpack.ml.settings.filterLists.table.itemCountColumnName', {
      defaultMessage: 'Item count'
    }),
    sortable: true,
    'data-test-subj': 'mlFilterListColumnItemCount'
  }, {
    field: 'used_by',
    name: _i18n.i18n.translate('xpack.ml.settings.filterLists.table.inUseColumnName', {
      defaultMessage: 'In use'
    }),
    render: usedBy => /*#__PURE__*/_react.default.createElement(UsedByIcon, {
      usedBy: usedBy
    }),
    sortable: true,
    'data-test-subj': 'mlFilterListColumnInUse'
  }];
  return columns;
}
function renderToolsRight(canCreateFilter, canDeleteFilter, selectedFilterLists, refreshFilterLists) {
  return [/*#__PURE__*/_react.default.createElement(NewFilterButton, {
    key: "new_filter_list",
    canCreateFilter: canCreateFilter
  }), /*#__PURE__*/_react.default.createElement(_delete_filter_list_modal.DeleteFilterListModal, {
    key: "delete_filter_list",
    canDeleteFilter: canDeleteFilter,
    selectedFilterLists: selectedFilterLists,
    refreshFilterLists: refreshFilterLists
  })];
}
function FilterListsTable({
  canCreateFilter,
  canDeleteFilter,
  filterLists,
  selectedFilterLists,
  setSelectedFilterLists,
  refreshFilterLists
}) {
  const sorting = {
    sort: {
      field: 'filter_id',
      direction: 'asc'
    }
  };
  const search = {
    toolsRight: renderToolsRight(canCreateFilter, canDeleteFilter, selectedFilterLists, refreshFilterLists),
    box: {
      incremental: true
    },
    filters: []
  };
  const tableSelection = {
    selectable: filterList => filterList.used_by === undefined || filterList.used_by.jobs.length === 0,
    selectableMessage: () => undefined,
    onSelectionChange: selection => setSelectedFilterLists(selection)
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, filterLists === undefined || filterLists.length === 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(NewFilterButton, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.settings.filterLists.table.noFiltersCreatedTitle",
    defaultMessage: "No filters have been created"
  })))))) : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlFilterListTableContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    className: "ml-filter-lists-table",
    items: filterLists,
    itemId: "filter_id",
    columns: getColumns(),
    search: search,
    pagination: true,
    sorting: sorting,
    selection: tableSelection,
    isSelectable: true,
    "data-test-subj": "mlFilterListsTable",
    rowProps: item => ({
      'data-test-subj': `mlFilterListRow row-${item.filter_id}`
    })
  })));
}
FilterListsTable.propTypes = {
  canCreateFilter: _propTypes.default.bool.isRequired,
  canDeleteFilter: _propTypes.default.bool.isRequired,
  filterLists: _propTypes.default.array,
  selectedFilterLists: _propTypes.default.array,
  setSelectedFilterLists: _propTypes.default.func.isRequired,
  refreshFilterLists: _propTypes.default.func.isRequired
};
UsedByIcon.displayName = 'UsedByIcon';