"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mlResultsService = void 0;
exports.mlResultsServiceProvider = mlResultsServiceProvider;
exports.useMlResultsService = useMlResultsService;
var _react = require("react");
var _result_service_rx = require("./result_service_rx");
var _results_service = require("./results_service");
var _ml_api_service = require("../ml_api_service");
var _kibana = require("../../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mlResultsService = exports.mlResultsService = mlResultsServiceProvider(_ml_api_service.ml);
function mlResultsServiceProvider(mlApiServices) {
  return {
    ...(0, _results_service.resultsServiceProvider)(mlApiServices),
    ...(0, _result_service_rx.resultsServiceRxProvider)(mlApiServices)
  };
}
function useMlResultsService() {
  const {
    services: {
      mlServices: {
        mlApiServices
      }
    }
  } = (0, _kibana.useMlKibana)();
  const resultsService = (0, _react.useMemo)(() => mlResultsServiceProvider(mlApiServices), [mlApiServices]);
  return resultsService;
}