"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.analyticsJobsCreationRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _queryString = require("query-string");
var _i18n = require("@kbn/i18n");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _ml = require("../../../contexts/ml");
var _locator = require("../../../../locator");
var _kibana = require("../../../contexts/kibana");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _resolvers = require("../../resolvers");
var _breadcrumbs = require("../../breadcrumbs");
var _load_new_job_capabilities = require("../../../services/new_job_capabilities/load_new_job_capabilities");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Page = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('../../../data_frame_analytics/pages/analytics_creation')))).Page
}));
const analyticsJobsCreationRouteFactory = (navigateToPath, basePath) => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.DATA_FRAME_ANALYTICS_CREATE_JOB),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps
  })),
  title: _i18n.i18n.translate('xpack.ml.dataFrameAnalytics.createJob.docTitle', {
    defaultMessage: 'Create Job'
  }),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('DATA_FRAME_ANALYTICS_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.dataFrameAnalyticsBreadcrumbs.dataFrameCreationLabel', {
      defaultMessage: 'Create Job'
    })
  }]
});
exports.analyticsJobsCreationRouteFactory = analyticsJobsCreationRouteFactory;
const PageWrapper = ({
  location
}) => {
  const {
    index,
    jobId,
    savedSearchId
  } = (0, _queryString.parse)(location.search, {
    sort: false
  });
  const {
    services: {
      data: {
        dataViews: dataViewsService
      },
      savedSearch: savedSearchService
    }
  } = (0, _kibana.useMlKibana)();
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetDataFrameAnalytics', 'canCreateDataFrameAnalytics'], {
    ...(0, _resolvers.basicResolvers)(),
    analyticsFields: () => (0, _load_new_job_capabilities.loadNewJobCapabilities)(index, savedSearchId, dataViewsService, savedSearchService, _load_new_job_capabilities.DATA_FRAME_ANALYTICS)
  });
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_ml.DataSourceContextProvider, null, /*#__PURE__*/_react.default.createElement(Page, {
    jobId: jobId
  })));
};