"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferenceApi = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InferenceApi = ({
  inferenceApis
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, inferenceApis.map((inferenceApi, i) => {
    const initialIsOpen = i <= 2;
    const modelId = inferenceApi.model_id;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: modelId
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: modelId,
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs"
      }, /*#__PURE__*/_react.default.createElement("h5", null, modelId)),
      paddingSize: "l",
      initialIsOpen: initialIsOpen
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      columns: 2
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": `mlTrainedModelPipelineDefinition_${modelId}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: 'xxs'
    }, /*#__PURE__*/_react.default.createElement("h6", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.expandedRow.inferenceApiDefinitionTitle",
      defaultMessage: "Definition"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      fontSize: "m",
      paddingSize: "m",
      overflowHeight: 300,
      isCopyable: true
    }, JSON.stringify(inferenceApi, null, 2)))))));
  }));
};
exports.InferenceApi = InferenceApi;