"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteModelsModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _trained_models = require("../services/ml_api_service/trained_models");
var _toast_notification_service = require("../services/toast_notification_service");
var _delete_space_aware_item_check_modal = require("../components/delete_space_aware_item_check_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteModelsModal = ({
  models,
  onClose
}) => {
  const trainedModelsApiService = (0, _trained_models.useTrainedModelsApiService)();
  const {
    displayErrorToast,
    displaySuccessToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const [canDeleteModel, setCanDeleteModel] = (0, _react.useState)(false);
  const [deletePipelines, setDeletePipelines] = (0, _react.useState)(false);
  const modelIds = models.map(m => m.model_id);
  const modelsWithPipelines = models.filter(m => (0, _mlIsPopulatedObject.isPopulatedObject)(m.pipelines));
  const modelsWithInferenceAPIs = models.filter(m => m.hasInferenceServices);
  const inferenceAPIsIDs = modelsWithInferenceAPIs.flatMap(model => {
    var _model$inference_apis;
    return ((_model$inference_apis = model.inference_apis) !== null && _model$inference_apis !== void 0 ? _model$inference_apis : []).map(inference => inference.model_id);
  });
  const pipelinesCount = modelsWithPipelines.reduce((acc, curr) => {
    return acc + Object.keys(curr.pipelines).length;
  }, 0);
  const deleteModels = (0, _react.useCallback)(async () => {
    try {
      await Promise.all(modelIds.map(modelId => trainedModelsApiService.deleteTrainedModel(modelId, {
        with_pipelines: deletePipelines,
        force: pipelinesCount > 0
      })));
      displaySuccessToast(_i18n.i18n.translate('xpack.ml.trainedModels.modelsList.successfullyDeletedMessage', {
        defaultMessage: '{modelsCount, plural, one {Model {modelIds}} other {# models}} {modelsCount, plural, one {has} other {have}} been successfully deleted',
        values: {
          modelsCount: modelIds.length,
          modelIds: modelIds.join(', ')
        }
      }));
    } catch (error) {
      displayErrorToast(error, _i18n.i18n.translate('xpack.ml.trainedModels.modelsList.fetchDeletionErrorMessage', {
        defaultMessage: '{modelsCount, plural, one {Model} other {Models}} deletion failed',
        values: {
          modelsCount: modelIds.length
        }
      }));
    }
    onClose(true);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [modelIds, trainedModelsApiService, deletePipelines, pipelinesCount]);
  return canDeleteModel ? /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose.bind(null, false),
    initialFocus: "[name=cancelModelDeletion]",
    "data-test-subj": "mlModelsDeleteModal"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.deleteModal.header",
    defaultMessage: "Delete {modelsCount, plural, one {{modelId}} other {# models}}?",
    values: {
      modelId: modelIds[0],
      modelsCount: modelIds.length
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, modelsWithPipelines.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.deleteModal.pipelinesWarningHeader",
      defaultMessage: "{modelsCount, plural, one {{modelId} has} other {# models have}} associated pipelines.",
      values: {
        modelsCount: modelsWithPipelines.length,
        modelId: modelsWithPipelines[0].model_id
      }
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.deleteModal.warningMessage",
    defaultMessage: "Deleting the trained model and its associated {pipelinesCount, plural, one {pipeline} other {pipelines}} will permanently remove these resources. Any process configured to send data to the {pipelinesCount, plural, one {pipeline} other {pipelines}} will no longer be able to do so once you delete the {pipelinesCount, plural, one {pipeline} other {pipelines}}. Deleting only the trained model will cause failures in the {pipelinesCount, plural, one {pipeline} other {pipelines}} that {pipelinesCount, plural, one {depends} other {depend}} on the model.",
    values: {
      pipelinesCount
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: 'delete-model-pipelines',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.deleteModal.approvePipelinesDeletionLabel",
      defaultMessage: "Delete {pipelinesCount, plural, one {pipeline} other {pipelines}}",
      values: {
        pipelinesCount
      }
    }),
    checked: deletePipelines,
    onChange: setDeletePipelines.bind(null, prev => !prev),
    "data-test-subj": "mlModelsDeleteModalDeletePipelinesCheckbox"
  })), /*#__PURE__*/_react.default.createElement("ul", null, modelsWithPipelines.flatMap(model => {
    return Object.keys(model.pipelines).map(pipelineId => /*#__PURE__*/_react.default.createElement("li", {
      key: pipelineId
    }, pipelineId));
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null, modelsWithInferenceAPIs.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.modelsList.deleteModal.inferenceAPIWarningHeader",
      defaultMessage: "{modelsCount, plural, one {{modelId} has} other {# models have}} associated inference services.",
      values: {
        modelsCount: modelsWithInferenceAPIs.length,
        modelId: modelsWithInferenceAPIs[0].model_id
      }
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("ul", null, inferenceAPIsIDs.map(inferenceAPIModelId => /*#__PURE__*/_react.default.createElement("li", {
    key: inferenceAPIModelId
  }, inferenceAPIModelId))), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.deleteModal.warningInferenceMessage",
    defaultMessage: "Deleting the trained model will cause failures in the inference {inferenceAPIsCount, plural, one {service} other {services}} that {inferenceAPIsCount, plural, one {depends} other {depend}} on the model.",
    values: {
      inferenceAPIsCount: inferenceAPIsIDs.length
    }
  })))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose.bind(null, false),
    name: "cancelModelDeletion"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.deleteModal.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: deleteModels.bind(null),
    fill: true,
    color: "danger",
    "data-test-subj": "mlModelsDeleteModalConfirmButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.modelsList.deleteModal.deleteButtonLabel",
    defaultMessage: "Delete"
  })))) : /*#__PURE__*/_react.default.createElement(_delete_space_aware_item_check_modal.DeleteSpaceAwareItemCheckModal, {
    ids: modelIds,
    mlSavedObjectType: "trained-model",
    canDeleteCallback: setCanDeleteModel.bind(null, true),
    onCloseCallback: onClose.bind(null, true),
    refreshJobsCallback: () => {},
    hasManagedJob: false
  });
};
exports.DeleteModelsModal = DeleteModelsModal;