"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WizardNav = exports.PreviousButton = exports.NextButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WizardNav = ({
  previous,
  previousActive = true,
  next,
  nextActive = true,
  children
}) => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, previous && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(PreviousButton, {
  previous: previous,
  previousActive: previousActive
})), next && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(NextButton, {
  next: next,
  nextActive: nextActive
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null)));
exports.WizardNav = WizardNav;
const PreviousButton = ({
  previous,
  previousActive = true
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  disabled: !previousActive,
  onClick: previous,
  iconType: "arrowLeft",
  iconSide: "left",
  "data-test-subj": "mlJobWizardNavButtonPrevious"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.newJob.wizard.previousStepButton",
  defaultMessage: "Previous"
}));
exports.PreviousButton = PreviousButton;
const NextButton = ({
  next,
  nextActive = true
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  fill: true,
  disabled: !nextActive,
  onClick: next,
  iconSide: "right",
  iconType: "arrowRight",
  "data-test-subj": "mlJobWizardNavButtonNext"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.newJob.wizard.nextStepButton",
  defaultMessage: "Next"
}));
exports.NextButton = NextButton;