"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PickFieldsStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _field_stats_flyout = require("../../../../../components/field_stats_flyout");
var _job_creator_context = require("../job_creator_context");
var _wizard_nav = require("../wizard_nav");
var _step_types = require("../step_types");
var _single_metric_view = require("./components/single_metric_view");
var _multi_metric_view = require("./components/multi_metric_view");
var _population_view = require("./components/population_view");
var _advanced_view = require("./components/advanced_view");
var _categorization_view = require("./components/categorization_view");
var _rare_view = require("./components/rare_view");
var _geo_view = require("./components/geo_view");
var _json_editor_flyout = require("../common/json_editor_flyout");
var _job_creator = require("../../../common/job_creator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PickFieldsStep = ({
  setCurrentStep,
  isCurrentStep
}) => {
  const {
    jobCreator,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [nextActive, setNextActive] = (0, _react.useState)(false);
  const [selectionValid, setSelectionValid] = (0, _react.useState)(false);
  const {
    setIsFlyoutVisible,
    setFieldName
  } = (0, _field_stats_flyout.useFieldStatsFlyoutContext)();
  (0, _react.useEffect)(() => {
    setNextActive(selectionValid && jobValidator.isPickFieldsStepValid);
    return () => {
      setIsFlyoutVisible(false);
      setFieldName(undefined);
    };
  }, [jobValidator, jobValidatorUpdated, selectionValid, setIsFlyoutVisible, setFieldName]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, isCurrentStep && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, (0, _job_creator.isSingleMetricJobCreator)(jobCreator) && /*#__PURE__*/_react.default.createElement(_single_metric_view.SingleMetricView, {
    isActive: isCurrentStep,
    setCanProceed: setSelectionValid
  }), (0, _job_creator.isMultiMetricJobCreator)(jobCreator) && /*#__PURE__*/_react.default.createElement(_multi_metric_view.MultiMetricView, {
    isActive: isCurrentStep,
    setCanProceed: setSelectionValid
  }), (0, _job_creator.isPopulationJobCreator)(jobCreator) && /*#__PURE__*/_react.default.createElement(_population_view.PopulationView, {
    isActive: isCurrentStep,
    setCanProceed: setSelectionValid
  }), (0, _job_creator.isAdvancedJobCreator)(jobCreator) && /*#__PURE__*/_react.default.createElement(_advanced_view.AdvancedView, {
    isActive: isCurrentStep,
    setCanProceed: setSelectionValid
  }), (0, _job_creator.isCategorizationJobCreator)(jobCreator) && /*#__PURE__*/_react.default.createElement(_categorization_view.CategorizationView, {
    isActive: isCurrentStep,
    setCanProceed: setSelectionValid
  }), (0, _job_creator.isRareJobCreator)(jobCreator) && /*#__PURE__*/_react.default.createElement(_rare_view.RareView, {
    isActive: isCurrentStep,
    setCanProceed: setSelectionValid
  }), (0, _job_creator.isGeoJobCreator)(jobCreator) && /*#__PURE__*/_react.default.createElement(_geo_view.GeoView, {
    isActive: isCurrentStep,
    setCanProceed: setSelectionValid
  }), /*#__PURE__*/_react.default.createElement(_wizard_nav.WizardNav, {
    previous: () => setCurrentStep((0, _job_creator.isAdvancedJobCreator)(jobCreator) ? _step_types.WIZARD_STEPS.ADVANCED_CONFIGURE_DATAFEED : _step_types.WIZARD_STEPS.TIME_RANGE),
    next: () => setCurrentStep(_step_types.WIZARD_STEPS.JOB_DETAILS),
    nextActive: nextActive
  }, (0, _job_creator.isAdvancedJobCreator)(jobCreator) && /*#__PURE__*/_react.default.createElement(_json_editor_flyout.JsonEditorFlyout, {
    isDisabled: false,
    jobEditorMode: _json_editor_flyout.EDITOR_MODE.EDITABLE,
    datafeedEditorMode: _json_editor_flyout.EDITOR_MODE.EDITABLE
  }))));
};
exports.PickFieldsStep = PickFieldsStep;