"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SplitCards = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _new_job = require("../../../../../../../../../common/constants/new_job");
require("./style.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SplitCards = exports.SplitCards = /*#__PURE__*/(0, _react.memo)(({
  fieldValues,
  splitField,
  children,
  numberOfDetectors,
  jobType,
  animate = false
}) => {
  const panels = [];
  function storePanels(panel, marginBottom) {
    if (panel !== null) {
      if (animate === false) {
        panel.style.marginBottom = `${marginBottom}px`;
      }
      panels.push({
        panel,
        marginBottom
      });
    }
  }
  function getBackPanels() {
    panels.length = 0;
    const fieldValuesCopy = [...fieldValues];
    fieldValuesCopy.shift();
    let margin = 5;
    const sideMargins = fieldValuesCopy.map((f, i) => margin += 10 - i).reverse();
    if (animate === true) {
      setTimeout(() => {
        panels.forEach(p => p.panel.style.marginBottom = `${p.marginBottom}px`);
      }, 100);
    }
    const SPACING = 100;
    const SPLIT_HEIGHT_MULTIPLIER = 1.6;
    return fieldValuesCopy.map((fieldName, i) => {
      const diff = (i + 1) * (SPLIT_HEIGHT_MULTIPLIER * (10 / fieldValuesCopy.length));
      const marginBottom = -SPACING + diff;
      const sideMargin = sideMargins[i];
      const style = {
        height: `${SPACING}px`,
        marginBottom: `-${SPACING}px`,
        marginLeft: `${sideMargin}px`,
        marginRight: `${sideMargin}px`,
        ...(animate ? {
          transition: 'margin 0.5s'
        } : {})
      };
      return /*#__PURE__*/_react.default.createElement("div", {
        key: fieldName,
        ref: ref => storePanels(ref, marginBottom),
        style: style
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        paddingSize: "m",
        className: "mlPickFields__splitCard",
        "data-test-subj": "mlSplitCard back"
      }, /*#__PURE__*/_react.default.createElement("div", {
        style: {
          fontWeight: 'bold',
          fontSize: 'small'
        },
        "data-test-subj": "mlSplitCardTitle"
      }, fieldName)));
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "mlDataSplit"
  }, (fieldValues.length === 0 || numberOfDetectors === 0) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children), fieldValues.length > 0 && numberOfDetectors > 0 && splitField !== null && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, (jobType === _new_job.JOB_TYPE.MULTI_METRIC || jobType === _new_job.JOB_TYPE.GEO) && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      fontSize: 'small'
    },
    "data-test-subj": `mlDataSplitTitle ${splitField.name}`
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.splitCards.dataSplitBy",
    defaultMessage: "Data split by {field}",
    values: {
      field: splitField.name
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), getBackPanels(), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    className: "mlPickFields__splitCard",
    "data-test-subj": "mlSplitCard front"
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      fontWeight: 'bold',
      fontSize: 'small'
    },
    "data-test-subj": "mlSplitCardTitle"
  }, fieldValues[0]), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)))));
});