"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolver = resolver;
var _quick_create_job = require("./quick_create_job");
var _new_job_utils = require("../utils/new_job_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resolver(deps, dashboardRisonString, dataViewIdRisonString, embeddableRisonString, geoFieldRisonString, splitFieldRisonString, fromRisonString, toRisonString, layerRisonString) {
  const {
    dataViews,
    kibanaConfig,
    timeFilter,
    dashboardService,
    mlApiServices
  } = deps;
  const defaultLayer = {
    query: (0, _new_job_utils.getDefaultQuery)(),
    filters: []
  };
  const dashboard = (0, _new_job_utils.getRisonValue)(dashboardRisonString, defaultLayer);
  const embeddable = (0, _new_job_utils.getRisonValue)(embeddableRisonString, defaultLayer);
  const layer = layerRisonString !== undefined ? (0, _new_job_utils.getRisonValue)(layerRisonString, defaultLayer) : defaultLayer;
  const geoField = (0, _new_job_utils.getRisonValue)(geoFieldRisonString, '');
  const splitField = (0, _new_job_utils.getRisonValue)(splitFieldRisonString, null);
  const dataViewId = (0, _new_job_utils.getRisonValue)(dataViewIdRisonString, '');
  const from = (0, _new_job_utils.getRisonValue)(fromRisonString, '');
  const to = (0, _new_job_utils.getRisonValue)(toRisonString, '');
  const jobCreator = new _quick_create_job.QuickGeoJobCreator(dataViews, kibanaConfig, timeFilter, dashboardService, mlApiServices);
  await jobCreator.createAndStashGeoJob(dataViewId, from, to, dashboard.query, dashboard.filters, embeddable.query, embeddable.filters, geoField, splitField, layer === null || layer === void 0 ? void 0 : layer.query);
}