"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolver = resolver;
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _quick_create_job = require("./quick_create_job");
var _new_job_utils = require("../utils/new_job_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resolver(deps, lensSavedObjectRisonString, fromRisonString, toRisonString, queryRisonString, filtersRisonString, layerIndexRisonString) {
  const {
    dataViews,
    lens,
    mlApiServices,
    timeFilter,
    kibanaConfig,
    dashboardService
  } = deps;
  if (lensSavedObjectRisonString === undefined) {
    throw new Error('Cannot create visualization');
  }
  const vis = _rison.default.decode(lensSavedObjectRisonString);
  if (!vis) {
    throw new Error('Cannot create visualization');
  }
  const query = (0, _new_job_utils.getRisonValue)(queryRisonString, (0, _new_job_utils.getDefaultQuery)());
  const filters = (0, _new_job_utils.getRisonValue)(filtersRisonString, []);
  const from = (0, _new_job_utils.getRisonValue)(fromRisonString, '');
  const to = (0, _new_job_utils.getRisonValue)(toRisonString, '');
  const layerIndex = (0, _new_job_utils.getRisonValue)(layerIndexRisonString, undefined);
  const jobCreator = new _quick_create_job.QuickLensJobCreator(lens, dataViews, kibanaConfig, timeFilter, dashboardService, mlApiServices);
  await jobCreator.createAndStashADJob(vis, from, to, query, filters, layerIndex);
}