"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapLoader = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _lodash = require("lodash");
var _chart_loader = require("../chart_loader");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const eq = (newArgs, lastArgs) => (0, _lodash.isEqual)(newArgs, lastArgs);
class MapLoader extends _chart_loader.ChartLoader {
  constructor(indexPattern, query, mapsPlugin) {
    super(indexPattern, query);
    (0, _defineProperty2.default)(this, "_getMapData", void 0);
    this._getMapData = mapsPlugin ? (0, _memoizeOne.default)(mapsPlugin.createLayerDescriptors.createESSearchSourceLayerDescriptor, eq) : null;
  }
  async getMapLayersForGeoJob(geoField, splitField, fieldValues, filters, savedSearchQuery) {
    const layerList = [];
    if (this._dataView.id !== undefined && geoField) {
      const {
        query
      } = savedSearchQuery !== null && savedSearchQuery !== void 0 ? savedSearchQuery : {};
      const queryString = fieldValues.length && splitField ? `${splitField.name}:${fieldValues[0]} ${query ? `and ${query}` : ''}` : `${query ? query : ''}`;
      const params = {
        indexPatternId: this._dataView.id,
        geoFieldName: geoField.name,
        geoFieldType: geoField.type,
        filters: filters !== null && filters !== void 0 ? filters : [],
        query: {
          query: queryString,
          language: 'kuery'
        }
      };
      const searchLayerDescriptor = this._getMapData ? await this._getMapData(params) : null;
      if (searchLayerDescriptor) {
        layerList.push(searchLayerDescriptor);
      }
    }
    return layerList;
  }
}
exports.MapLoader = MapLoader;