"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALIDATOR_SEVERITY = void 0;
exports.cardinalityValidator = cardinalityValidator;
exports.groupIdsValidator = groupIdsValidator;
exports.isCardinalityModelPlotHigh = isCardinalityModelPlotHigh;
exports.jobIdValidator = jobIdValidator;
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _ml_api_service = require("../../../../services/ml_api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let VALIDATOR_SEVERITY = exports.VALIDATOR_SEVERITY = /*#__PURE__*/function (VALIDATOR_SEVERITY) {
  VALIDATOR_SEVERITY[VALIDATOR_SEVERITY["ERROR"] = 0] = "ERROR";
  VALIDATOR_SEVERITY[VALIDATOR_SEVERITY["WARNING"] = 1] = "WARNING";
  return VALIDATOR_SEVERITY;
}({});
const jobExistsErrorMessage = _i18n.i18n.translate('xpack.ml.newJob.wizard.validateJob.asyncJobNameAlreadyExists', {
  defaultMessage: 'Job ID already exists. A job ID cannot be the same as an existing job or group.'
});
const groupExistsErrorMessage = _i18n.i18n.translate('xpack.ml.newJob.wizard.validateJob.asyncGroupNameAlreadyExists', {
  defaultMessage: 'Group ID already exists. A group ID cannot be the same as an existing group or job.'
});
function isCardinalityModelPlotHigh(cardinalityValidationResult) {
  return cardinalityValidationResult.modelPlotCardinality !== undefined;
}
function cardinalityValidator(jobCreator$) {
  return (0, _rxjs.combineLatest)([jobCreator$.pipe((0, _rxjs.pluck)('modelPlot')), jobCreator$.pipe((0, _rxjs.filter)(jobCreator => {
    return jobCreator === null || jobCreator === void 0 ? void 0 : jobCreator.modelPlot;
  }), (0, _rxjs.map)(jobCreator => {
    return {
      jobCreator,
      analysisConfigString: JSON.stringify(jobCreator.jobConfig.analysis_config, null, 2)
    };
  }), (0, _rxjs.distinctUntilChanged)((prev, curr) => {
    return prev.analysisConfigString === curr.analysisConfigString;
  }), (0, _rxjs.switchMap)(({
    jobCreator
  }) => {
    // Perform a cardinality check only with enabled model plot.
    return _ml_api_service.ml.validateCardinality$({
      ...jobCreator.jobConfig,
      datafeed_config: jobCreator.datafeedConfig
    }).pipe((0, _rxjs.map)(validationResults => {
      for (const validationResult of validationResults) {
        if (isCardinalityModelPlotHigh(validationResult)) {
          return {
            highCardinality: {
              value: validationResult.modelPlotCardinality,
              severity: VALIDATOR_SEVERITY.WARNING
            }
          };
        }
      }
      return null;
    }));
  }), (0, _rxjs.startWith)(null))]).pipe((0, _rxjs.map)(([isModelPlotEnabled, cardinalityValidationResult]) => {
    return isModelPlotEnabled ? cardinalityValidationResult : null;
  }));
}
function jobIdValidator(jobCreator$) {
  return jobCreator$.pipe((0, _rxjs.map)(jobCreator => {
    return jobCreator.jobId;
  }),
  // No need to perform an API call if the analysis configuration hasn't been changed
  (0, _rxjs.distinctUntilChanged)((prevJobId, currJobId) => prevJobId === currJobId), (0, _rxjs.switchMap)(jobId => _ml_api_service.ml.jobs.jobsExist$([jobId], true)), (0, _rxjs.map)(jobExistsResults => {
    const jobs = Object.values(jobExistsResults);
    const valid = (jobs === null || jobs === void 0 ? void 0 : jobs[0].exists) === false;
    return {
      jobIdExists: {
        valid,
        ...(valid ? {} : {
          message: jobExistsErrorMessage
        })
      }
    };
  }));
}
function groupIdsValidator(jobCreator$) {
  return jobCreator$.pipe((0, _rxjs.map)(jobCreator => jobCreator.groups),
  // No need to perform an API call if the analysis configuration hasn't been changed
  (0, _rxjs.distinctUntilChanged)((prevGroups, currGroups) => JSON.stringify(prevGroups) === JSON.stringify(currGroups)), (0, _rxjs.switchMap)(groups => {
    return _ml_api_service.ml.jobs.jobsExist$(groups, true);
  }), (0, _rxjs.map)(jobExistsResults => {
    const groups = Object.values(jobExistsResults);
    // only match jobs that exist but aren't groups.
    // as we should allow existing groups to be reused.
    const valid = groups.some(g => g.exists === true && g.isGroup === false) === false;
    return {
      groupIdsExist: {
        valid,
        ...(valid ? {} : {
          message: groupExistsErrorMessage
        })
      }
    };
  }));
}