"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteJobModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utils = require("../utils");
var _jobs_list = require("../../../../../../common/constants/jobs_list");
var _delete_space_aware_item_check_modal = require("../../../../components/delete_space_aware_item_check_modal");
var _jobs_utils = require("../../../jobs_utils");
var _managed_jobs_warning_callout = require("../confirm_modals/managed_jobs_warning_callout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteJobModal = ({
  setShowFunction,
  unsetShowFunction,
  refreshJobs
}) => {
  const [deleting, setDeleting] = (0, _react.useState)(false);
  const [modalVisible, setModalVisible] = (0, _react.useState)(false);
  const [adJobs, setAdJobs] = (0, _react.useState)([]);
  const [canDelete, setCanDelete] = (0, _react.useState)(false);
  const [deleteUserAnnotations, setDeleteUserAnnotations] = (0, _react.useState)(false);
  const [deleteAlertingRules, setDeleteAlertingRules] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (typeof setShowFunction === 'function') {
      setShowFunction(showModal);
    }
    return () => {
      if (typeof unsetShowFunction === 'function') {
        unsetShowFunction();
      }
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const showModal = (0, _react.useCallback)(jobs => {
    setAdJobs(jobs);
    setModalVisible(true);
    setDeleting(false);
    setDeleteUserAnnotations(false);
  }, []);
  const {
    jobIds,
    hasManagedJob,
    hasAlertingRules
  } = (0, _react.useMemo)(() => {
    return {
      jobIds: adJobs.map(({
        id
      }) => id),
      hasManagedJob: adJobs.some(job => (0, _jobs_utils.isManagedJob)(job)),
      hasAlertingRules: adJobs.some(job => Array.isArray(job.alertingRules) && job.alertingRules.length > 0)
    };
  }, [adJobs]);
  const closeModal = (0, _react.useCallback)(() => {
    setModalVisible(false);
    setCanDelete(false);
  }, []);
  const deleteJob = (0, _react.useCallback)(() => {
    setDeleting(true);
    (0, _utils.deleteJobs)(jobIds.map(id => ({
      id
    })), deleteUserAnnotations, deleteAlertingRules);
    setTimeout(() => {
      closeModal();
      refreshJobs();
    }, _jobs_list.BLOCKED_JOBS_REFRESH_INTERVAL_MS);
  }, [jobIds, deleteUserAnnotations, deleteAlertingRules, closeModal, refreshJobs]);
  if (modalVisible === false || jobIds.length === 0) {
    return null;
  }
  if (canDelete) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      "data-test-subj": "mlDeleteJobConfirmModal",
      onClose: closeModal
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.deleteJobModal.deleteJobsTitle",
      defaultMessage: "Delete {jobsCount, plural, one {{jobId}} other {# jobs}}?",
      values: {
        jobsCount: jobIds.length,
        jobId: jobIds[0]
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement("p", null, deleting === true ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.deleteJobModal.deletingJobsStatusLabel",
      defaultMessage: "Deleting jobs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("div", {
      style: {
        textAlign: 'center'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l"
    }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasManagedJob ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_managed_jobs_warning_callout.ManagedJobsWarningCallout, {
      jobsCount: jobIds.length,
      action: _i18n.i18n.translate('xpack.ml.jobsList.deleteJobModal.deleteAction', {
        defaultMessage: 'deleting'
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.deleteJobModal.deleteMultipleJobsDescription",
      defaultMessage: "Deleting {jobsCount, plural, one {a job} other {multiple jobs}} can be time consuming. {jobsCount, plural, one {It} other {They}} will be deleted in the background and may not disappear from the jobs list instantly.",
      values: {
        jobsCount: jobIds.length
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.ml.jobsList.deleteJobModal.deleteUserAnnotations', {
        defaultMessage: 'Delete annotations'
      }),
      checked: deleteUserAnnotations,
      onChange: e => setDeleteUserAnnotations(e.target.checked),
      "data-test-subj": "mlDeleteJobConfirmModalDeleteAnnotationsSwitch"
    }), hasAlertingRules ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 's'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.ml.jobsList.resetJobModal.deleteAlertingRules', {
        defaultMessage: 'Delete alerting rules'
      }),
      checked: deleteAlertingRules,
      onChange: e => setDeleteAlertingRules(e.target.checked)
    })) : null)))), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: closeModal,
      disabled: deleting
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.deleteJobModal.cancelButtonLabel",
      defaultMessage: "Cancel"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: deleteJob,
      fill: true,
      disabled: deleting,
      color: "danger",
      "data-test-subj": "mlDeleteJobConfirmModalButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.deleteJobModal.deleteButtonLabel",
      defaultMessage: "Delete"
    })))));
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_delete_space_aware_item_check_modal.DeleteSpaceAwareItemCheckModal, {
      ids: jobIds,
      mlSavedObjectType: "anomaly-detector",
      canDeleteCallback: () => {
        setCanDelete(true);
      },
      onCloseCallback: closeModal,
      refreshJobsCallback: refreshJobs,
      hasManagedJob: hasManagedJob
    }));
  }
};
exports.DeleteJobModal = DeleteJobModal;