"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExplorerUrlState = useExplorerUrlState;
var _mlUrlState = require("@kbn/ml-url-state");
var _locator = require("../../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useExplorerUrlState() {
  /**
   * Originally `mlExplorerSwimlane` resided directly in the app URL state (`_a` URL state key).
   * With current URL structure it has been moved under the `explorer` key of the app state (_a).
   */
  const [legacyExplorerState] = (0, _mlUrlState.usePageUrlState)('mlExplorerSwimlane');
  return (0, _mlUrlState.usePageUrlState)(_locator.ML_PAGES.ANOMALY_EXPLORER, {
    mlExplorerSwimlane: legacyExplorerState,
    mlExplorerFilter: {}
  });
}