"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_BY_JOB_LABEL = exports.SWIM_LANE_DEFAULT_PAGE_SIZE = exports.SWIMLANE_TYPE = exports.OVERALL_LABEL = exports.MAX_INFLUENCER_FIELD_VALUES = exports.MAX_INFLUENCER_FIELD_NAMES = exports.MAX_CATEGORY_EXAMPLES = exports.FILTER_ACTION = exports.EXPLORER_ACTION = exports.DRAG_SELECT_ACTION = exports.CHART_TYPE = exports.ANOMALY_SWIM_LANE_HARD_LIMIT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Contains values for ML anomaly explorer.
 */

const DRAG_SELECT_ACTION = exports.DRAG_SELECT_ACTION = {
  NEW_SELECTION: 'newSelection',
  ELEMENT_SELECT: 'elementSelect',
  DRAG_START: 'dragStart'
};
const EXPLORER_ACTION = exports.EXPLORER_ACTION = {
  CLEAR_EXPLORER_DATA: 'clearExplorerData',
  CLEAR_INFLUENCER_FILTER_SETTINGS: 'clearInfluencerFilterSettings',
  CLEAR_JOBS: 'clearJobs',
  JOB_SELECTION_CHANGE: 'jobSelectionChange',
  SET_CHARTS_DATA_LOADING: 'setChartsDataLoading',
  SET_EXPLORER_DATA: 'setExplorerData'
};
const FILTER_ACTION = exports.FILTER_ACTION = {
  ADD: '+',
  REMOVE: '-'
};
const SWIMLANE_TYPE = exports.SWIMLANE_TYPE = {
  OVERALL: 'overall',
  VIEW_BY: 'viewBy'
};
const CHART_TYPE = exports.CHART_TYPE = {
  EVENT_DISTRIBUTION: 'event_distribution',
  POPULATION_DISTRIBUTION: 'population_distribution',
  SINGLE_METRIC: 'single_metric',
  GEO_MAP: 'geo_map'
};
const MAX_CATEGORY_EXAMPLES = exports.MAX_CATEGORY_EXAMPLES = 10;

/**
 * Maximum amount of top influencer to fetch.
 */
const MAX_INFLUENCER_FIELD_VALUES = exports.MAX_INFLUENCER_FIELD_VALUES = 10;
const MAX_INFLUENCER_FIELD_NAMES = exports.MAX_INFLUENCER_FIELD_NAMES = 50;
const VIEW_BY_JOB_LABEL = exports.VIEW_BY_JOB_LABEL = _i18n.i18n.translate('xpack.ml.explorer.jobIdLabel', {
  defaultMessage: 'job ID'
});
const OVERALL_LABEL = exports.OVERALL_LABEL = _i18n.i18n.translate('xpack.ml.explorer.overallLabel', {
  defaultMessage: 'Overall'
});

/**
 * Hard limitation for the size of terms
 * aggregations on influencers values.
 */
const ANOMALY_SWIM_LANE_HARD_LIMIT = exports.ANOMALY_SWIM_LANE_HARD_LIMIT = 1000;

/**
 * Default page size for the anomaly swim lane.
 */
const SWIM_LANE_DEFAULT_PAGE_SIZE = exports.SWIM_LANE_DEFAULT_PAGE_SIZE = 10;