"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionAlertsStateService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _public = require("@kbn/data-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _alerts = require("../../../../common/constants/alerts");
var _state_service = require("../../services/state_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AnomalyDetectionAlertsStateService extends _state_service.StateService {
  constructor(_anomalyTimelineStateServices, data, timefilter) {
    super();
    /**
     * Subject that holds the anomaly detection alerts from the alert-as-data index.
     * @private
     */
    (0, _defineProperty2.default)(this, "_aadAlerts$", new _rxjs.BehaviorSubject([]));
    (0, _defineProperty2.default)(this, "_isLoading$", new _rxjs.BehaviorSubject(true));
    (0, _defineProperty2.default)(this, "anomalyDetectionAlerts$", this._aadAlerts$.asObservable());
    /**
     * Query for fetching alerts data based on the job selection and time range.
     */
    (0, _defineProperty2.default)(this, "alertsQuery$", void 0);
    (0, _defineProperty2.default)(this, "isLoading$", this._isLoading$.asObservable());
    /**
     * Observable for the alerts within the swim lane selection.
     */
    (0, _defineProperty2.default)(this, "selectedAlerts$", void 0);
    (0, _defineProperty2.default)(this, "countByStatus$", this._aadAlerts$.pipe((0, _rxjs.map)(alerts => {
      return this.countAlertsByStatus(alerts);
    })));
    this._anomalyTimelineStateServices = _anomalyTimelineStateServices;
    this.data = data;
    this.timefilter = timefilter;
    this.selectedAlerts$ = (0, _rxjs.combineLatest)([this._aadAlerts$, this._anomalyTimelineStateServices.getSelectedCells$().pipe((0, _rxjs.map)(cells => cells === null || cells === void 0 ? void 0 : cells.times))]).pipe((0, _rxjs.map)(([alerts, selectedTimes]) => {
      if (!Array.isArray(selectedTimes)) return null;
      return alerts.filter(alert => alert[_alerts.ALERT_ANOMALY_TIMESTAMP] >= selectedTimes[0] * 1000 && alert[_alerts.ALERT_ANOMALY_TIMESTAMP] <= selectedTimes[1] * 1000);
    }));
    const timeUpdates$ = this.timefilter.getTimeUpdate$().pipe((0, _rxjs.startWith)(null), (0, _rxjs.map)(() => this.timefilter.getTime()));
    this.alertsQuery$ = (0, _rxjs.combineLatest)([this._anomalyTimelineStateServices.getSwimLaneJobs$(), timeUpdates$]).pipe(
    // Create a result query from the input
    (0, _rxjs.map)(([selectedJobs, timeRange]) => {
      return {
        bool: {
          filter: [{
            term: {
              [_ruleDataUtils.ALERT_RULE_TYPE_ID]: _alerts.ML_ALERT_TYPES.ANOMALY_DETECTION
            }
          }, {
            range: {
              [_alerts.ALERT_ANOMALY_TIMESTAMP]: {
                gte: timeRange.from,
                lte: timeRange.to
              }
            }
          }, {
            terms: {
              [_alerts.ALERT_ANOMALY_DETECTION_JOB_ID]: selectedJobs.map(job => job.id)
            }
          }]
        }
      };
    }));
    this._init();
  }

  /**
   * Count the number of alerts by status.
   * @param alerts
   */
  countAlertsByStatus(alerts) {
    return alerts.reduce((acc, alert) => {
      if (!(0, _mlIsDefined.isDefined)(acc[alert[_ruleDataUtils.ALERT_STATUS]])) {
        acc[alert[_ruleDataUtils.ALERT_STATUS]] = 0;
      } else {
        acc[alert[_ruleDataUtils.ALERT_STATUS]]++;
      }
      return acc;
    }, {
      active: 0,
      recovered: 0
    });
  }
  _initSubscriptions() {
    const subscription = new _rxjs.Subscription();
    subscription.add(this.alertsQuery$.pipe((0, _rxjs.tap)(() => {
      this._isLoading$.next(true);
    }), (0, _rxjs.debounceTime)(300), (0, _rxjs.switchMap)(query => {
      return this.data.search.search({
        featureIds: [_ruleDataUtils.AlertConsumers.ML],
        query
      }, {
        strategy: 'privateRuleRegistryAlertsSearchStrategy'
      }).pipe((0, _rxjs.catchError)(error => {
        // Catch error to prevent the observable from completing
        return _rxjs.EMPTY;
      }));
    })).subscribe(response => {
      if (!(0, _public.isRunningResponse)(response)) {
        this._aadAlerts$.next(response.rawResponse.hits.hits.map(({
          fields
        }) => {
          var _fields$ALERT_END;
          if (!(0, _mlIsDefined.isDefined)(fields)) return;
          const anomalyScore = Number(fields[_alerts.ALERT_ANOMALY_SCORE][0]);
          return {
            id: fields[_ruleDataUtils.ALERT_UUID][0],
            [_ruleDataUtils.ALERT_RULE_NAME]: fields[_ruleDataUtils.ALERT_RULE_NAME][0],
            [_alerts.ALERT_ANOMALY_SCORE]: anomalyScore,
            [_alerts.ALERT_ANOMALY_DETECTION_JOB_ID]: fields[_alerts.ALERT_ANOMALY_DETECTION_JOB_ID][0],
            [_alerts.ALERT_ANOMALY_TIMESTAMP]: new Date(fields[_alerts.ALERT_ANOMALY_TIMESTAMP][0]).getTime(),
            [_ruleDataUtils.ALERT_START]: fields[_ruleDataUtils.ALERT_START][0],
            // Can be undefined if the alert is still active
            [_ruleDataUtils.ALERT_END]: (_fields$ALERT_END = fields[_ruleDataUtils.ALERT_END]) === null || _fields$ALERT_END === void 0 ? void 0 : _fields$ALERT_END[0],
            [_ruleDataUtils.ALERT_STATUS]: fields[_ruleDataUtils.ALERT_STATUS][0],
            [_ruleDataUtils.ALERT_DURATION]: fields[_ruleDataUtils.ALERT_DURATION][0],
            color: (0, _mlAnomalyUtils.getSeverityColor)(anomalyScore)
          };
        }).filter(_mlIsDefined.isDefined));
        this._isLoading$.next(false);
      }
    }));
    return subscription;
  }
}
exports.AnomalyDetectionAlertsStateService = AnomalyDetectionAlertsStateService;