"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OTHER_CLASS_ID = exports.MAX_COLUMNS = exports.ACTUAL_CLASS_ID = void 0;
exports.getColumnData = getColumnData;
exports.getTrailingControlColumns = getTrailingControlColumns;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COL_INITIAL_WIDTH = 165; // in pixels

const ACTUAL_CLASS_ID = exports.ACTUAL_CLASS_ID = 'actual_class';
const OTHER_CLASS_ID = exports.OTHER_CLASS_ID = 'other';
const MAX_COLUMNS = exports.MAX_COLUMNS = 6;
function getColumnData(confusionMatrixData) {
  const colData = [];
  const columns = [{
    id: ACTUAL_CLASS_ID,
    display: /*#__PURE__*/_react.default.createElement("span", null),
    initialWidth: COL_INITIAL_WIDTH
  }];
  let showOther = false;
  for (const classData of confusionMatrixData) {
    const otherCount = classData.other_predicted_class_doc_count;
    if (otherCount > 0) {
      showOther = true;
    }
    const col = {
      actual_class: classData.actual_class,
      actual_class_doc_count: classData.actual_class_doc_count,
      other: otherCount,
      predicted_classes_count: {}
    };
    const predictedClasses = classData.predicted_classes || [];
    columns.push({
      id: classData.actual_class,
      initialWidth: COL_INITIAL_WIDTH
    });
    for (let i = 0; i < predictedClasses.length; i++) {
      const predictedClass = predictedClasses[i].predicted_class;
      const predictedClassCount = predictedClasses[i].count;
      col.predicted_classes_count[predictedClass] = predictedClassCount;
    }
    colData.push(col);
  }
  if (showOther) {
    columns.push({
      id: OTHER_CLASS_ID,
      initialWidth: COL_INITIAL_WIDTH
    });
  }
  return {
    columns,
    columnData: colData
  };
}
function getTrailingControlColumns(numColumns, setShowFullColumns) {
  return [{
    id: 'actions',
    width: 60,
    headerCellRender: () => /*#__PURE__*/_react.default.createElement("span", null, `${numColumns} more`),
    rowCellRender: function RowCellRender() {
      const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        isOpen: isPopoverOpen,
        anchorPosition: "upCenter",
        button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.showActions', {
            defaultMessage: 'Show actions'
          }),
          iconType: "boxesHorizontal",
          color: "text",
          onClick: () => setIsPopoverOpen(!isPopoverOpen)
        }),
        closePopover: () => setIsPopoverOpen(false),
        ownFocus: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        onClick: () => setShowFullColumns(true)
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        grow: false,
        textAlign: "center"
      }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.classificationExploration.showAllColumns', {
        defaultMessage: 'Show all columns'
      }))));
    }
  }];
}