"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuntimeMappingsEditor = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _codeEditor = require("@kbn/code-editor");
var _mlRuntimeFieldUtils = require("@kbn/ml-runtime-field-utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuntimeMappingsEditor = exports.RuntimeMappingsEditor = /*#__PURE__*/(0, _react.memo)(({
  convertToJson,
  xJsonMode,
  setAdvancedRuntimeMappingsConfig,
  setIsRuntimeMappingsEditorApplyButtonEnabled,
  advancedEditorRuntimeMappingsLastApplied,
  advancedRuntimeMappingsConfig
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlDataFrameAnalyticsAdvancedRuntimeMappingsEditor"
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    height: 250,
    languageId: 'json',
    onChange: d => {
      setAdvancedRuntimeMappingsConfig(d);

      // Disable the "Apply"-Button if the config hasn't changed.
      if (advancedEditorRuntimeMappingsLastApplied === d) {
        setIsRuntimeMappingsEditorApplyButtonEnabled(false);
        return;
      }

      // Enable Apply button so user can remove previously created runtime field
      if (d === '') {
        setIsRuntimeMappingsEditorApplyButtonEnabled(true);
        return;
      }

      // Try to parse the string passed on from the editor.
      // If parsing fails, the "Apply"-Button will be disabled
      try {
        const parsedJson = JSON.parse(convertToJson(d));
        setIsRuntimeMappingsEditorApplyButtonEnabled((0, _mlRuntimeFieldUtils.isRuntimeMappings)(parsedJson));
      } catch (e) {
        setIsRuntimeMappingsEditorApplyButtonEnabled(false);
      }
    },
    options: {
      ariaLabel: _i18n.i18n.translate('xpack.ml.dataframe.analytics.createWizard.runtimeMappings.advancedEditorAriaLabel', {
        defaultMessage: 'Advanced runtime editor'
      }),
      automaticLayout: true,
      fontSize: 12,
      scrollBeyondLastLine: false,
      quickSuggestions: true,
      minimap: {
        enabled: false
      },
      wordWrap: 'on',
      wrappingIndent: 'indent'
    },
    value: advancedRuntimeMappingsConfig
  }));
}, (prevProps, nextProps) => (0, _lodash.isEqual)(pickProps(prevProps), pickProps(nextProps)));
function pickProps(props) {
  return [props.advancedEditorRuntimeMappingsLastApplied, props.advancedRuntimeMappingsConfig];
}