"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestPipeline = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _eui = require("@elastic/eui");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _codeEditor = require("@kbn/code-editor");
var _kibana = require("../../../contexts/kibana");
var _get_pipeline_config = require("../get_pipeline_config");
var _validation_utils = require("../../../../../common/util/validation_utils");
var _retry_create_data_view = require("../retry_create_data_view");
var _types = require("../types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sourceIndexMissingMessage = _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.test.sourceIndexMissing', {
  defaultMessage: 'The source index used to train the model is missing. Enter text for documents to test the pipeline.'
});
const TestPipeline = exports.TestPipeline = /*#__PURE__*/(0, _react.memo)(({
  state,
  sourceIndex,
  mode
}) => {
  const [simulatePipelineResult, setSimulatePipelineResult] = (0, _react.useState)();
  const [simulatePipelineError, setSimulatePipelineError] = (0, _react.useState)();
  const [sourceIndexMissingError, setSourceIndexMissingError] = (0, _react.useState)();
  const [sampleDocsString, setSampleDocsString] = (0, _react.useState)('');
  const [lastFetchedSampleDocsString, setLastFetchedSampleDocsString] = (0, _react.useState)('');
  const [isValid, setIsValid] = (0, _react.useState)(true);
  const [showCallOut, setShowCallOut] = (0, _react.useState)(true);
  const {
    esSearch,
    trainedModels: {
      trainedModelPipelineSimulate
    }
  } = (0, _kibana.useMlApiContext)();
  const {
    notifications: {
      toasts
    },
    services: {
      docLinks: {
        links
      }
    }
  } = (0, _kibana.useMlKibana)();
  const isSmallerViewport = (0, _eui.useIsWithinMaxBreakpoint)('s');
  const accordionId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const pipelineConfig = (0, _react.useMemo)(() => (0, _get_pipeline_config.getPipelineConfig)(state), [state]);
  const requestBody = (0, _react.useMemo)(() => {
    const body = {
      pipeline: pipelineConfig,
      docs: []
    };
    if ((0, _validation_utils.isValidJson)(sampleDocsString)) {
      body.docs = JSON.parse(sampleDocsString);
    }
    return body;
  }, [pipelineConfig, sampleDocsString]);
  const simulatePipeline = async () => {
    try {
      const result = await trainedModelPipelineSimulate(pipelineConfig, JSON.parse(sampleDocsString));
      setSimulatePipelineResult(result);
    } catch (error) {
      // eslint-disable-next-line no-console
      console.error(error);
      const errorProperties = (0, _mlErrorUtils.extractErrorProperties)(error);
      setSimulatePipelineError(error);
      toasts.danger({
        title: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.test.errorSimulatingPipeline', {
          defaultMessage: 'Unable to simulate pipeline.'
        }),
        body: errorProperties.message,
        toastLifeTimeMs: 5000
      });
    }
  };
  const clearResults = () => {
    setSimulatePipelineResult(undefined);
    setSimulatePipelineError(undefined);
  };
  const onChange = json => {
    setSampleDocsString(json);
    const valid = (0, _validation_utils.isValidJson)(json);
    setIsValid(valid);
  };
  const getDocs = (0, _react.useCallback)(async body => {
    let records = [];
    let resp;
    try {
      resp = await esSearch(body);
      if (resp && resp.hits.total.value > 0) {
        records = resp.hits.hits;
      }
    } catch (error) {
      // eslint-disable-next-line no-console
      console.error(error);
    }
    setSampleDocsString(JSON.stringify(records, null, 2));
    setSimulatePipelineResult(undefined);
    setLastFetchedSampleDocsString(JSON.stringify(records, null, 2));
    setIsValid(true);
  }, [esSearch]);
  const {
    getSampleDoc,
    getRandomSampleDoc
  } = (0, _react.useMemo)(() => ({
    getSampleDoc: async () => {
      getDocs({
        index: sourceIndex,
        body: {
          size: 1
        }
      });
    },
    getRandomSampleDoc: async () => {
      getDocs({
        index: sourceIndex,
        body: {
          size: 1,
          query: {
            function_score: {
              query: {
                match_all: {}
              },
              random_score: {}
            }
          }
        }
      });
    }
  }), [getDocs, sourceIndex]);
  (0, _react.useEffect)(function checkSourceIndexExists() {
    async function ensureSourceIndexExists() {
      const resp = await (0, _retry_create_data_view.checkIndexExists)(sourceIndex);
      const indexExists = resp.resp && resp.resp[sourceIndex] && resp.resp[sourceIndex].exists;
      if (indexExists === false) {
        setSourceIndexMissingError(sourceIndexMissingMessage);
      }
    }
    if (sourceIndex) {
      ensureSourceIndexExists();
    }
  }, [sourceIndex, sourceIndexMissingError]);
  (0, _react.useEffect)(function fetchSampleDocsFromSource() {
    if (sourceIndex && sourceIndexMissingError === undefined) {
      getSampleDoc();
    }
  }, [sourceIndex, getSampleDoc, sourceIndexMissingError]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    "data-test-subj": "mlTrainedModelsInferenceTestStep"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.test.title', {
    defaultMessage: 'Test the pipeline results'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, mode === _types.TEST_PIPELINE_MODE.STEP ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.test.optionalCallout', {
    defaultMessage: 'This is an optional step.'
  })), "\xA0") : null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.test.description",
    defaultMessage: "Run a simulation of the pipeline to confirm it produces the anticipated results. {simulatePipelineDocsLink}",
    values: {
      simulatePipelineDocsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        target: "_blank",
        href: links.apis.simulatePipeline
      }, "Learn more.")
    }
  }), /*#__PURE__*/_react.default.createElement("br", null)), state.targetField && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.test.targetFieldHint",
    defaultMessage: "Check for the target field {targetField} for the prediction in the Result tab.",
    values: {
      targetField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, state.targetField)
    }
  }), /*#__PURE__*/_react.default.createElement("br", null)), sampleDocsString && sourceIndexMissingError === undefined ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.test.sourceIndexDocText",
    defaultMessage: "The provided sample document is taken from the source index used to train the model."
  }) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), sourceIndexMissingError && showCallOut ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    onDismiss: () => {
      setShowCallOut(false);
    },
    size: "s",
    title: sourceIndexMissingError,
    iconType: "warning"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })) : null, mode === _types.TEST_PIPELINE_MODE.STAND_ALONE ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.test.viewRequest",
      defaultMessage: "View request body"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    overflowHeight: "400px",
    "data-test-subj": "mlTrainedModelsInferenceTestStepConfigBlock"
  }, JSON.stringify(requestBody, null, 2)))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: simulatePipeline,
    disabled: sampleDocsString === '' || !isValid
  }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.test.runButton', {
    defaultMessage: 'Simulate pipeline'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: clearResults,
    disabled: simulatePipelineResult === undefined
  }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.test.clearResultsButton', {
    defaultMessage: 'Clear results'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: () => setSampleDocsString(lastFetchedSampleDocsString),
    disabled: sampleDocsString === '' || sampleDocsString === lastFetchedSampleDocsString
  }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.test.resetSampleDocsButton', {
    defaultMessage: 'Reset'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: getRandomSampleDoc,
    disabled: sampleDocsString === ''
  }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.test.reloadSampleDocsButton', {
    defaultMessage: 'Reload'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.test.subtitle.documents', {
    defaultMessage: 'Raw document'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.test.subtitle.result', {
    defaultMessage: 'Result'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, {
    direction: isSmallerViewport ? 'vertical' : 'horizontal',
    css: (0, _react2.css)`
                min-height: calc(${_uiTheme.euiThemeVars.euiSizeXL} * 10);
              `
  }, (EuiResizablePanel, EuiResizableButton) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    grow: true,
    hasBorder: true,
    initialSize: 50,
    paddingSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    "data-test-subj": "mlTrainedModelsInferenceTestDocsEditor",
    languageId: "json",
    options: {
      automaticLayout: true,
      lineNumbers: 'off',
      tabSize: 2
    },
    value: sampleDocsString,
    onChange: onChange
  })), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    grow: false,
    hasBorder: true,
    initialSize: 50,
    paddingSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    "data-test-subj": "mlTrainedModelsInferenceTestResult"
  }, simulatePipelineError ? JSON.stringify(simulatePipelineError, null, 2) : simulatePipelineResult ? JSON.stringify(simulatePipelineResult, null, 2) : '{}'))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))));
});