"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessorConfiguration = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _codeEditor = require("@kbn/code-editor");
var _constants = require("../constants");
var _validation = require("../validation");
var _validation_utils = require("../../../../../common/util/validation_utils");
var _save_changes_button = require("./save_changes_button");
var _kibana = require("../../../contexts/kibana");
var _additional_advanced_settings = require("./additional_advanced_settings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDefaultFieldMapString() {
  return JSON.stringify({
    field_map: {
      incoming_field: 'field_the_model_expects'
    }
  }, null, 2);
}
const ProcessorConfiguration = exports.ProcessorConfiguration = /*#__PURE__*/(0, _react.memo)(({
  condition,
  fieldMap,
  handleAdvancedConfigUpdate,
  inferenceConfig,
  modelInputFields,
  modelInferenceConfig,
  modelType,
  setHasUnsavedChanges,
  tag
}) => {
  const {
    services: {
      docLinks: {
        links
      }
    }
  } = (0, _kibana.useMlKibana)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [editInferenceConfig, setEditInferenceConfig] = (0, _react.useState)(false);
  const [editFieldMapping, setEditFieldMapping] = (0, _react.useState)(false);
  const [inferenceConfigString, setInferenceConfigString] = (0, _react.useState)(JSON.stringify(inferenceConfig, null, 2));
  const [inferenceConfigError, setInferenceConfigError] = (0, _react.useState)();
  const [fieldMapError, setFieldMapError] = (0, _react.useState)();
  const [fieldMappingString, setFieldMappingString] = (0, _react.useState)(fieldMap ? JSON.stringify(fieldMap, null, 2) : getDefaultFieldMapString());
  const [isInferenceConfigValid, setIsInferenceConfigValid] = (0, _react.useState)(true);
  const [isFieldMapValid, setIsFieldMapValid] = (0, _react.useState)(true);
  const handleInferenceConfigChange = json => {
    setInferenceConfigString(json);
    const valid = (0, _validation_utils.isValidJson)(json);
    setIsInferenceConfigValid(valid);
  };
  const updateInferenceConfig = () => {
    const invalidInferenceConfigMessage = (0, _validation.validateInferenceConfig)(JSON.parse(inferenceConfigString), modelType);
    if (invalidInferenceConfigMessage === undefined) {
      handleAdvancedConfigUpdate({
        inferenceConfig: JSON.parse(inferenceConfigString)
      });
      setHasUnsavedChanges(false);
      setEditInferenceConfig(false);
      setInferenceConfigError(undefined);
    } else {
      setHasUnsavedChanges(true);
      setIsInferenceConfigValid(false);
      setInferenceConfigError(invalidInferenceConfigMessage);
    }
  };
  const resetInferenceConfig = () => {
    setInferenceConfigString(JSON.stringify(modelInferenceConfig, null, 2));
    setIsInferenceConfigValid(true);
    setInferenceConfigError(undefined);
  };
  const clearFieldMap = () => {
    setFieldMappingString('{}');
    setIsFieldMapValid(true);
    setFieldMapError(undefined);
  };
  const handleFieldMapChange = json => {
    setFieldMappingString(json);
    const valid = (0, _validation_utils.isValidJson)(json);
    setIsFieldMapValid(valid);
  };
  const updateFieldMap = () => {
    var _modelInputFields$fie;
    const invalidFieldMapMessage = (0, _validation.validateFieldMap)((_modelInputFields$fie = modelInputFields.field_names) !== null && _modelInputFields$fie !== void 0 ? _modelInputFields$fie : [], JSON.parse(fieldMappingString));
    if (invalidFieldMapMessage === undefined) {
      handleAdvancedConfigUpdate({
        fieldMap: JSON.parse(fieldMappingString)
      });
      setHasUnsavedChanges(false);
      setEditFieldMapping(false);
      setFieldMapError(undefined);
    } else {
      setHasUnsavedChanges(true);
      setIsFieldMapValid(false);
      setFieldMapError(invalidFieldMapMessage);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "mlTrainedModelsInferencePipelineProcessorConfigStep"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.inferenceConfigurationTitle', {
    defaultMessage: 'Inference configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.description",
    defaultMessage: "The inference type and its options. Unless otherwise specified, the default configuration options are used. {inferenceDocsLink}.",
    values: {
      inferenceDocsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        target: "_blank",
        href: links.ingest.inference
      }, "Learn more.")
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "mlTrainedModelsInferencePipelineInferenceConfigEditButton",
      iconType: "pencil",
      size: "xs",
      onClick: () => {
        if (!editInferenceConfig === false) {
          setInferenceConfigError(undefined);
          setIsInferenceConfigValid(true);
        }
        setEditInferenceConfig(!editInferenceConfig);
      }
    }, editInferenceConfig ? _constants.CANCEL_EDIT_MESSAGE : _constants.EDIT_MESSAGE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, editInferenceConfig ? /*#__PURE__*/_react.default.createElement(_save_changes_button.SaveChangesButton, {
      onClick: updateInferenceConfig,
      disabled: isInferenceConfigValid === false
    }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, editInferenceConfig ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: resetInferenceConfig
    }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.resetInferenceConfigButton', {
      defaultMessage: 'Reset'
    })) : null)),
    error: inferenceConfigError !== null && inferenceConfigError !== void 0 ? inferenceConfigError : inferenceConfigError,
    isInvalid: inferenceConfigError !== undefined || inferenceConfigError !== undefined,
    "data-test-subj": "mlTrainedModelsInferencePipelineInferenceConfigEditor"
  }, editInferenceConfig ? /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    height: 300,
    languageId: "json",
    options: {
      automaticLayout: true,
      lineNumbers: 'off',
      tabSize: 2
    },
    value: inferenceConfigString,
    onChange: handleInferenceConfigChange
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    "data-test-subj": "mlTrainedModelsInferencePipelineInferenceConfigBlock"
  }, JSON.stringify(inferenceConfig, null, 2)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.fieldMapTitle', {
    defaultMessage: 'Fields'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.fieldMapDescriptionTwo",
    defaultMessage: "The model expects certain input fields. {fieldsList}",
    values: {
      fieldsList: /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        button: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => setIsPopoverOpen(!isPopoverOpen)
        }, "You can review them here."),
        isOpen: isPopoverOpen,
        closePopover: () => setIsPopoverOpen(false),
        anchorPosition: "downLeft"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        isCopyable: true
      }, JSON.stringify(modelInputFields, null, 2)))
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.fieldMapExtendedDescription",
    defaultMessage: "If the fields for the incoming data differ, a {fieldMap} must be created to map the input document field name to the name of the field that the model expects. It must be in JSON format. {inferenceDocsLink}",
    values: {
      fieldMap: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'field_map'),
      inferenceDocsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        target: "_blank",
        href: links.ingest.inference
      }, "Learn more.")
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      justifyContent: "flexStart"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "mlTrainedModelsInferencePipelineFieldMapEditButton",
      iconType: "pencil",
      size: "xs",
      onClick: () => {
        const editingState = !editFieldMapping;
        if (editingState === false) {
          setFieldMapError(undefined);
          setIsFieldMapValid(true);
          setHasUnsavedChanges(false);
        }
        setEditFieldMapping(editingState);
      }
    }, editFieldMapping ? _constants.CANCEL_EDIT_MESSAGE : fieldMap !== undefined ? _constants.EDIT_MESSAGE : _constants.CREATE_FIELD_MAPPING_MESSAGE)), editFieldMapping ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_save_changes_button.SaveChangesButton, {
      onClick: updateFieldMap,
      disabled: isFieldMapValid === false
    })) : null, editFieldMapping ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: clearFieldMap
    }, _constants.CLEAR_BUTTON_LABEL)) : null),
    error: fieldMapError,
    isInvalid: fieldMapError !== undefined,
    "data-test-subj": "mlTrainedModelsInferencePipelineFieldMapEdit"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !editFieldMapping ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    overflowHeight: 350,
    "data-test-subj": "mlTrainedModelsInferencePipelineFieldMapBlock"
  }, JSON.stringify(fieldMap !== null && fieldMap !== void 0 ? fieldMap : {}, null, 2)) : null, editFieldMapping ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    height: 300,
    languageId: "json",
    options: {
      automaticLayout: true,
      lineNumbers: 'off',
      tabSize: 2
    },
    value: fieldMappingString,
    onChange: handleFieldMapChange
  })) : null))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_additional_advanced_settings.AdditionalAdvancedSettings, {
    handleAdvancedConfigUpdate: handleAdvancedConfigUpdate,
    condition: condition,
    tag: tag
  })));
});