"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobSelector = JobSelector;
exports.getInitialGroupsMap = getInitialGroupsMap;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlUrlState = require("@kbn/ml-url-state");
require("./_index.scss");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _locator = require("../../../locator");
var _id_badges = require("./id_badges");
var _job_selector_flyout = require("./job_selector_flyout");
var _storage = require("../../../../common/types/storage");
var _feedback_button = require("../feedback_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mergeSelection(jobIds, groupObjs, singleSelection) {
  if (singleSelection) {
    return jobIds;
  }
  const selectedIds = [];
  const alreadySelected = [];
  groupObjs.forEach(group => {
    selectedIds.push(group.groupId);
    alreadySelected.push(...group.jobIds);
  });
  jobIds.forEach(jobId => {
    // Add jobId if not already included in group selection
    if (alreadySelected.includes(jobId) === false) {
      selectedIds.push(jobId);
    }
  });
  return selectedIds;
}
function getInitialGroupsMap(selectedGroups) {
  const map = {};
  if (selectedGroups.length) {
    selectedGroups.forEach(group => {
      map[group.groupId] = group.jobIds;
    });
  }
  return map;
}
function JobSelector({
  dateFormatTz,
  singleSelection,
  timeseriesOnly
}) {
  var _globalState$ml$jobId, _globalState$ml, _globalState$ml$group, _globalState$ml2;
  const [globalState, setGlobalState] = (0, _mlUrlState.useUrlState)('_g');
  const [applyTimeRangeConfig, setApplyTimeRangeConfig] = (0, _mlLocalStorage.useStorage)(_storage.ML_APPLY_TIME_RANGE_CONFIG, true);
  const selectedJobIds = (_globalState$ml$jobId = globalState === null || globalState === void 0 ? void 0 : (_globalState$ml = globalState.ml) === null || _globalState$ml === void 0 ? void 0 : _globalState$ml.jobIds) !== null && _globalState$ml$jobId !== void 0 ? _globalState$ml$jobId : [];
  const selectedGroups = (_globalState$ml$group = globalState === null || globalState === void 0 ? void 0 : (_globalState$ml2 = globalState.ml) === null || _globalState$ml2 === void 0 ? void 0 : _globalState$ml2.groups) !== null && _globalState$ml$group !== void 0 ? _globalState$ml$group : [];
  const [maps, setMaps] = (0, _react.useState)({
    groupsMap: getInitialGroupsMap(selectedGroups),
    jobsMap: {}
  });
  const [selectedIds, setSelectedIds] = (0, _react.useState)(mergeSelection(selectedJobIds, selectedGroups, singleSelection));
  const [showAllBarBadges, setShowAllBarBadges] = (0, _react.useState)(false);
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);

  // Ensure JobSelectionBar gets updated when selection via globalState changes.
  (0, _react.useEffect)(() => {
    setSelectedIds(mergeSelection(selectedJobIds, selectedGroups, singleSelection));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify([selectedJobIds, selectedGroups])]);
  function closeFlyout() {
    setIsFlyoutVisible(false);
  }
  function showFlyout() {
    setIsFlyoutVisible(true);
  }
  function handleJobSelectionClick() {
    showFlyout();
  }
  const applySelection = (0, _react.useCallback)(({
    newSelection,
    jobIds,
    groups: newGroups,
    time
  }) => {
    setSelectedIds(newSelection);
    setGlobalState({
      ml: {
        jobIds,
        groups: newGroups
      },
      ...(time !== undefined ? {
        time
      } : {})
    });
    closeFlyout();
  }, [setGlobalState, setSelectedIds]);
  function renderJobSelectionBar() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "xs",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, selectedIds.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      responsive: false,
      gutterSize: "xs",
      alignItems: "center",
      "data-test-subj": "mlJobSelectionBadges"
    }, /*#__PURE__*/_react.default.createElement(_id_badges.IdBadges, {
      limit: _job_selector_flyout.BADGE_LIMIT,
      maps: maps,
      onLinkClick: () => setShowAllBarBadges(!showAllBarBadges),
      selectedIds: selectedIds,
      showAllBarBadges: showAllBarBadges
    })) : /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobSelector.noJobsSelectedLabel",
      defaultMessage: "No jobs selected"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      iconType: "pencil",
      onClick: handleJobSelectionClick,
      "data-test-subj": "mlButtonEditJobSelection"
    }, _i18n.i18n.translate('xpack.ml.jobSelector.jobSelectionButton', {
      defaultMessage: 'Edit job selection'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_feedback_button.FeedBackButton, {
      jobIds: selectedIds,
      page: singleSelection ? _locator.ML_PAGES.SINGLE_METRIC_VIEWER : _locator.ML_PAGES.ANOMALY_EXPLORER
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "s"
    }));
  }
  function renderFlyout() {
    if (isFlyoutVisible) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
        onClose: closeFlyout,
        "data-test-subj": "mlFlyoutJobSelector",
        "aria-labelledby": "jobSelectorFlyout"
      }, /*#__PURE__*/_react.default.createElement(_job_selector_flyout.JobSelectorFlyoutContent, {
        dateFormatTz: dateFormatTz,
        timeseriesOnly: timeseriesOnly,
        singleSelection: singleSelection,
        selectedIds: selectedIds,
        onSelectionConfirmed: applySelection,
        onJobsFetched: setMaps,
        onFlyoutClose: closeFlyout,
        maps: maps,
        applyTimeRangeConfig: applyTimeRangeConfig,
        onTimeRangeConfigChange: setApplyTimeRangeConfig
      }));
    }
  }
  return /*#__PURE__*/_react.default.createElement("div", null, renderJobSelectionBar(), renderFlyout());
}