"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldStatsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_field_stats_flytout_context = require("./use_field_stats_flytout_context");
var _field_stats_content = require("./field_stats_content");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldStatsFlyout = ({
  dataView,
  fieldStatsServices,
  timeRangeMs,
  dslQuery
}) => {
  const {
    setIsFlyoutVisible,
    isFlyoutVisible,
    fieldName
  } = (0, _use_field_stats_flytout_context.useFieldStatsFlyoutContext)();
  const closeFlyout = (0, _react.useCallback)(() => setIsFlyoutVisible(false), []); // eslint-disable-line react-hooks/exhaustive-deps
  const pushedFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'mlJobCreationWizardFieldStats'
  });
  if (isFlyoutVisible) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      type: "push",
      size: "xs",
      onClose: closeFlyout,
      "aria-labelledby": pushedFlyoutTitleId,
      "data-test-subj": "mlFieldStatsFlyout"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h3", {
      id: pushedFlyoutTitleId
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.fieldContextFlyoutTitle",
      defaultMessage: "Field statistics"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      css: (0, _react2.css)`
            width: 300px;
          `
    }, /*#__PURE__*/_react.default.createElement("b", null, fieldName), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_field_stats_content.FieldStatsContent, {
      dataView: dataView,
      fieldStatsServices: fieldStatsServices,
      timeRangeMs: timeRangeMs,
      dslQuery: dslQuery
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: closeFlyout
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.fieldContextFlyoutCloseButton",
      defaultMessage: "Close"
    }))));
  }
  return null;
};
exports.FieldStatsFlyout = FieldStatsFlyout;