"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogCategorizationPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/aiops-plugin/public");
var _data_source_context = require("../contexts/ml/data_source_context");
var _kibana = require("../contexts/kibana");
var _ml = require("../contexts/ml");
var _help_menu = require("../components/help_menu");
var _page_header = require("../components/page_header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogCategorizationPage = () => {
  const {
    services
  } = (0, _kibana.useMlKibana)();
  const {
    showNodeInfo
  } = (0, _ml.useEnabledFeatures)();
  const {
    selectedDataView: dataView,
    selectedSavedSearch: savedSearch
  } = (0, _data_source_context.useDataSource)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: false,
    alignItems: 'center',
    gutterSize: 'm'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.logCategorization.pageHeader",
    defaultMessage: "Log pattern analysis"
  })))), dataView && /*#__PURE__*/_react.default.createElement(_public.LogCategorization, {
    dataView: dataView,
    savedSearch: savedSearch,
    showFrozenDataTierChoice: showNodeInfo,
    appDependencies: (0, _lodash.pick)(services, ['analytics', 'application', 'charts', 'data', 'executionContext', 'fieldFormats', 'http', 'i18n', 'lens', 'notifications', 'share', 'storage', 'theme', 'uiActions', 'uiSettings', 'unifiedSearch'])
  }), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: services.docLinks.links.ml.guide
  }));
};
exports.LogCategorizationPage = LogCategorizationPage;