"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSettings = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _time_interval_control = require("../time_interval_control");
var _alerts = require("../../../common/constants/alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AdvancedSettings = exports.AdvancedSettings = /*#__PURE__*/_react.default.memo(({
  value,
  onChange
}) => {
  var _value$topNBuckets;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "mlAnomalyAlertAdvancedSettings",
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetectionAlert.advancedSettingsLabel",
      defaultMessage: "Advanced settings"
    }),
    "data-test-subj": 'mlAnomalyAlertAdvancedSettingsTrigger'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    gutterSize: 's',
    titleSize: 'xxs',
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetectionAlert.lookbackIntervalLabel",
      defaultMessage: "Lookback interval"
    })),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 'xs'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetectionAlert.lookbackIntervalDescription",
      defaultMessage: "Time interval to query the anomalies data during each rule condition check. By default, is derived from the bucket span of the job and the query delay of the datafeed."
    }))
  }, /*#__PURE__*/_react.default.createElement(_time_interval_control.TimeIntervalControl, {
    value: value.lookbackInterval,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetectionAlert.lookbackIntervalLabel",
      defaultMessage: "Lookback interval"
    }),
    onChange: update => {
      onChange({
        lookbackInterval: update
      });
    },
    "data-test-subj": 'mlAnomalyAlertLookbackInterval'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    gutterSize: 's',
    titleSize: 'xxs',
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetectionAlert.topNBucketsLabel",
      defaultMessage: "Number of latest buckets"
    })),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 'xs'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetectionAlert.topNBucketsDescription",
      defaultMessage: "The number of latest buckets to check to obtain the highest anomaly."
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetectionAlert.topNBucketsLabel",
      defaultMessage: "Number of latest buckets"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: (_value$topNBuckets = value.topNBuckets) !== null && _value$topNBuckets !== void 0 ? _value$topNBuckets : _alerts.TOP_N_BUCKETS_COUNT,
    min: 1,
    onChange: e => {
      onChange({
        topNBuckets: Number(e.target.value)
      });
    },
    "data-test-subj": 'mlAnomalyAlertTopNBuckets'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: 'm'
  }));
});