"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNodeDetailsRedirect = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNodeDetailsRedirect = () => {
  const location = (0, _reactRouterDom.useLocation)();
  const {
    services: {
      application: {
        currentAppId$
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const appId = (0, _useObservable.default)(currentAppId$);
  const getNodeDetailUrl = (0, _react.useCallback)(({
    nodeType,
    nodeId,
    search
  }) => {
    const {
      to,
      from,
      ...rest
    } = search;
    return {
      app: 'metrics',
      pathname: `link-to/${nodeType}-detail/${nodeId}`,
      search: {
        ...rest,
        ...(to && from ? {
          to: `${to}`,
          from: `${from}`
        } : undefined),
        // While we don't have a shared state between all page in infra, this makes it possible to restore a page state when returning to the previous route
        ...(location.search || location.pathname ? {
          state: JSON.stringify({
            originAppId: appId,
            originSearch: location.search,
            originPathname: location.pathname
          })
        } : undefined)
      }
    };
  }, [location.pathname, appId, location.search]);
  return {
    getNodeDetailUrl
  };
};
exports.useNodeDetailsRedirect = useNodeDetailsRedirect;