"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.node = void 0;
var _i18n = require("@kbn/i18n");
var _formulas = require("../formulas");
var _constants = require("../../../../shared/charts/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nodeCpuCapacity = {
  id: 'nodeCpuCapacity',
  chartType: 'xy',
  title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.kubernetes.nodeCpuCapacity', {
    defaultMessage: 'Node CPU Capacity'
  }),
  layers: [{
    seriesType: 'area',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.nodeCpuCapacity, _formulas.formulas.nodeCpuUsed]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const nodeMemoryCapacity = {
  id: 'nodeMemoryCapacity',
  chartType: 'xy',
  title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.kubernetes.nodeMemoryCapacity', {
    defaultMessage: 'Node Memory Capacity'
  }),
  layers: [{
    seriesType: 'area',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.nodeMemoryCapacity, _formulas.formulas.nodeMemoryUsed]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const nodeDiskCapacity = {
  id: 'nodeDiskCapacity',
  chartType: 'xy',
  title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.kubernetes.nodeDiskCapacity', {
    defaultMessage: 'Node Disk Capacity'
  }),
  layers: [{
    seriesType: 'area',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.nodeDiskCapacity, _formulas.formulas.nodeDiskUsed]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const nodePodCapacity = {
  id: 'nodePodCapacity',
  chartType: 'xy',
  title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.kubernetes.nodePodCapacity', {
    defaultMessage: 'Node Pod Capacity'
  }),
  layers: [{
    seriesType: 'area',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.nodePodCapacity, _formulas.formulas.nodePodUsed]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const node = exports.node = {
  xy: {
    nodeCpuCapacity,
    nodeMemoryCapacity,
    nodeDiskCapacity,
    nodePodCapacity
  }
};