"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.disk = void 0;
var _i18n = require("@kbn/i18n");
var _formulas = require("../formulas");
var _constants = require("../../../shared/charts/constants");
var _formulas$diskSpaceAv, _formulas$diskIORead$, _formulas$diskIOWrite, _formulas$diskReadThr, _formulas$diskWriteTh, _formulas$diskUsage$l;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const diskIOReadWrite = {
  id: 'diskIOReadWrite',
  chartType: 'xy',
  title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.diskIOPS', {
    defaultMessage: 'Disk IOPS'
  }),
  layers: [{
    seriesType: 'area',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [{
      ..._formulas.formulas.diskIORead,
      label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.read', {
        defaultMessage: 'Read'
      })
    }, {
      ..._formulas.formulas.diskIOWrite,
      label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.write', {
        defaultMessage: 'Write'
      })
    }]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const diskUsageByMountPoint = {
  id: 'diskUsageByMountPoint',
  chartType: 'xy',
  title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.diskUsageByMountingPoint', {
    defaultMessage: 'Disk Usage by Mount Point'
  }),
  layers: [{
    seriesType: 'area',
    type: 'series',
    xAxis: '@timestamp',
    breakdown: {
      type: 'topValues',
      field: 'system.filesystem.mount_point',
      size: 5
    },
    yAxis: [{
      ..._formulas.formulas.diskUsageAverage,
      label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.diskUsage.label.used', {
        defaultMessage: 'Used'
      })
    }]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_LEGEND,
  ..._constants.DEFAULT_XY_YBOUNDS,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const diskThroughputReadWrite = {
  id: 'diskThroughputReadWrite',
  chartType: 'xy',
  title: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.diskThroughput', {
    defaultMessage: 'Disk Throughput'
  }),
  layers: [{
    seriesType: 'area',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [{
      ..._formulas.formulas.diskReadThroughput,
      label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.read', {
        defaultMessage: 'Read'
      })
    }, {
      ..._formulas.formulas.diskWriteThroughput,
      label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.write', {
        defaultMessage: 'Write'
      })
    }]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const diskSpaceAvailable = {
  id: 'diskSpaceAvailable',
  chartType: 'xy',
  title: (_formulas$diskSpaceAv = _formulas.formulas.diskSpaceAvailable.label) !== null && _formulas$diskSpaceAv !== void 0 ? _formulas$diskSpaceAv : '',
  layers: [{
    seriesType: 'line',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.diskSpaceAvailable]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const diskIORead = {
  id: 'diskIORead',
  chartType: 'xy',
  title: (_formulas$diskIORead$ = _formulas.formulas.diskIORead.label) !== null && _formulas$diskIORead$ !== void 0 ? _formulas$diskIORead$ : '',
  layers: [{
    seriesType: 'line',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.diskIORead]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const diskIOWrite = {
  id: 'diskIOWrite',
  chartType: 'xy',
  title: (_formulas$diskIOWrite = _formulas.formulas.diskIOWrite.label) !== null && _formulas$diskIOWrite !== void 0 ? _formulas$diskIOWrite : '',
  layers: [{
    seriesType: 'line',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.diskIOWrite]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const diskReadThroughput = {
  id: 'diskReadThroughput',
  chartType: 'xy',
  title: (_formulas$diskReadThr = _formulas.formulas.diskReadThroughput.label) !== null && _formulas$diskReadThr !== void 0 ? _formulas$diskReadThr : '',
  layers: [{
    seriesType: 'line',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.diskReadThroughput]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const diskWriteThroughput = {
  id: 'diskWriteThroughput',
  chartType: 'xy',
  title: (_formulas$diskWriteTh = _formulas.formulas.diskWriteThroughput.label) !== null && _formulas$diskWriteTh !== void 0 ? _formulas$diskWriteTh : '',
  layers: [{
    seriesType: 'line',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.diskWriteThroughput]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const diskUsageMetric = {
  id: 'diskUsage',
  chartType: 'metric',
  title: (_formulas$diskUsage$l = _formulas.formulas.diskUsage.label) !== null && _formulas$diskUsage$l !== void 0 ? _formulas$diskUsage$l : '',
  trendLine: true,
  ..._formulas.formulas.diskUsage
};
const disk = exports.disk = {
  xy: {
    diskThroughputReadWrite,
    diskUsageByMountPoint,
    diskIOReadWrite,
    diskSpaceAvailable,
    diskIORead,
    diskIOWrite,
    diskReadThroughput,
    diskWriteThroughput
  },
  metric: {
    diskUsage: diskUsageMetric
  }
};