"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIMESTAMP_FIELD = exports.TIEBREAKER_FIELD = exports.POD_FIELD = exports.O11Y_AAD_FIELDS = exports.METRICS_INDEX_PATTERN = exports.METRICS_FEATURE_ID = exports.METRICS_APP = exports.MESSAGE_FIELD = exports.LOGS_INDEX_PATTERN = exports.LOGS_FEATURE_ID = exports.LOGS_APP_TARGET = exports.LOGS_APP = exports.HOST_FIELD = exports.DISCOVER_APP_TARGET = exports.CONTAINER_FIELD = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METRICS_INDEX_PATTERN = exports.METRICS_INDEX_PATTERN = 'metrics-*,metricbeat-*';
const LOGS_INDEX_PATTERN = exports.LOGS_INDEX_PATTERN = 'logs-*,filebeat-*,kibana_sample_data_logs*';
const METRICS_APP = exports.METRICS_APP = 'metrics';
const LOGS_APP = exports.LOGS_APP = 'logs';
const METRICS_FEATURE_ID = exports.METRICS_FEATURE_ID = 'infrastructure';
const LOGS_FEATURE_ID = exports.LOGS_FEATURE_ID = 'logs';
const TIMESTAMP_FIELD = exports.TIMESTAMP_FIELD = '@timestamp';
const MESSAGE_FIELD = exports.MESSAGE_FIELD = 'message';
const TIEBREAKER_FIELD = exports.TIEBREAKER_FIELD = '_doc';
const HOST_FIELD = exports.HOST_FIELD = 'host.name';
const CONTAINER_FIELD = exports.CONTAINER_FIELD = 'container.id';
const POD_FIELD = exports.POD_FIELD = 'kubernetes.pod.uid';
const DISCOVER_APP_TARGET = exports.DISCOVER_APP_TARGET = 'discover';
const LOGS_APP_TARGET = exports.LOGS_APP_TARGET = 'logs-ui';
const O11Y_AAD_FIELDS = exports.O11Y_AAD_FIELDS = ['cloud.*', 'host.*', 'orchestrator.*', 'container.*', 'labels.*', 'tags'];